
/*
 *	intr.c
 *
 *	QNX 4
 *
 *	(C) Copyright 1997 by Robert Krten, all rights reserved.
 *
 *	This module contains the interrupt handler for the X-10.
 *
 *	1997 01 11	R. Krten		created
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <conio.h>
#include <i86.h>
#include <sys/irqinfo.h>
#include <sys/proxy.h>

#include "x10.h"

extern	char	*progname;					// main.c
extern	char	*version;					// version.c

extern	int		opti;						// main.c, IRQ to attach to
extern	int		optp;						// main.c, hardware port to use
extern	int		optv;						// main.c, verbosity flag

pid_t			proxyIRQ_PID;				// PID of proxy created
int				interruptID;				// ID of interrupt attached

volatile Serial_t SerialPort;				// info about the serial port
char recordBuffer [4096];
int recptr = 0;

pid_t far		intHandler (void);

void
initInterrupts ()
{
	if ((proxyIRQ_PID = qnx_proxy_attach (0, 0, 0, 15)) == -1) {
		fprintf (stderr, "%s:  can't allocate IRQ proxy\n", progname);
		perror (NULL);
		exit (1);
	}

	if ((interruptID = qnx_hint_attach (opti, &intHandler, FP_SEG (&optp))) == -1) {
		fprintf (stderr, "%s:  can't attach to hardware interrupt IRQ %d\n", progname, opti);
		perror (NULL);
		exit (1);
	}
}

terminateInterrupts ()
{
	qnx_hint_detach (interruptID);
}

#pragma off (check_stack);
pid_t far intHandler ()
{
	SerialPort.rx = SerialPort.msr = SerialPort.lsr = 0xff;

	SerialPort.iir = inp (optp + R_II) & IIR_MASK;
	if (SerialPort.iir & 1) {			// no interrupt
		return (0);
	}

	switch (SerialPort.iir) {
	case	IIR_MSR:
		SerialPort.msr = inp (optp + R_MS);
		return (proxyIRQ_PID);
		break;
	case	IIR_THE:
		break;
	case	IIR_RX:
		SerialPort.rx = inp (optp + R_RX);
		break;
	case	IIR_LSR:
		SerialPort.lsr = inp (optp + R_LS);
		break;
	}
	return (0);
}

