
/*
 *	main.c
 *
 *	QNX 4, main.c shell version 0.005
 *
 *	(C) Copyright 1997 by Robert Krten, all rights reserved.
 *
 *	This module represents the main module for the X-10 server.
 *
 *	This program will
 *
 *	1997 01 11	R. Krten		created
*/

#ifdef __USAGE

%C [options] arguments

where [options] are optional parameters chosen from:
    -i irq         serial chip's IRQ (decimal) (default is 3)
    -n name        registered name of driver (default is /PARSE/X10)
    -p port        serial chip's I/O port (hexadecimal) (default is 2F8)
    -v             verbose operation

This is the X-10 driver.

#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/sched.h>

#include "x10.h"

static	void	optproc (int, char **);

char	*progname = "x10";
char	*blankname= "   ";
extern	char	*version;					// version.c

char	*optn;								// name of server, default /PARSE/X10
int		opti;								// IRQ, default 3
int		optp;								// I/O Port, default 2f8
int		optv;								// Verbosity, default 0 == off

main (argc, argv)
int		argc;
char	**argv;
{
	optproc (argc, argv);
	printf ("The X-10 Home Controller Driver, version %s\n", version);
	printf ("(C) Copyright PARSE Software Devices, all rights reserved\n");
	initPort (optp);
	initServer ();
	initInterrupts ();
	initFSM ();
	qnx_scheduler (0, 0, SCHED_RR, 15, 0);
	serve ();
}

void
usageError ()
{
	fprintf (stderr, "%s:  error in use, type \"use %s\" for usage\n", progname, progname);
	exit (1);
}

void
optproc (argc, argv)
int		argc;
char	**argv;
{
	int		opt;

	if (!argc) {
		usageError ();
	}

	opti = 3;
	optp = 0x2f8;
	optn = NULL;

	while ((opt = getopt (argc, argv, "n:i:p:v")) != -1) {
		switch (opt) {
		case	'n':
			optn = optarg;
			break;
		case	'i':
			opti = atoi (optarg);
			break;
		case	'p':
			sscanf (optarg, "%x", &optp);
			break;
		case	'v':
			optv++;
			if (optv > 1) {
				printf ("Verbosity is %d\n", optv);
			}
			break;
		default:
			usageError ();
			break;
		}
	}

	if (optn == NULL) {
		optn = "/PARSE/X10";
	}

	for (; optind < argc; optind++) {
		printf ("additional parameters [%d] -%s-\n", optind, argv [optind]);
	}

	if (optv) {
		printf ("PORT 0x%X IRQ %d Registered as \"%s\"\n", optp, opti, optn);
	}
}

