
/*
 *	serial.h
 *
 *	QNX 4
 *
 *	(C) Copyright 1997 by Robert Krten, all rights reserved.
 *
 *	This module contains the manifest constants and declarations for
 *	the serial port 8250/16450/16550 chips.
 *
 *	1997 01 11	R. Krten		created
*/

/*
 *	Register Definitions (offsets from base port)
*/

#define	R_RX					0					// receive buffer
#define	R_TX					0					// transmit buffer
#define	R_DL					0					// divisor latch low
#define	R_IE					1					// interrupt enable
#define	R_DH					1					// divisor latch high
#define	R_II					2					// interrupt information
#define	R_LC					3					// line control
#define	R_MC					4					// modem control
#define	R_LS					5					// line status
#define	R_MS					6					// modem status
#define	R_SCRATCH				7					// scratch register

//	LCR register encodings

#define	LCR_5_DATA_BITS			(0x00 << 0)
#define	LCR_6_DATA_BITS			(0x01 << 0)
#define	LCR_7_DATA_BITS			(0x02 << 0)
#define	LCR_8_DATA_BITS			(0x03 << 0)
#define	LCR_DATA_BITS_MASK		(0x03 << 0)

#define	LCR_1_STOP_BIT			(0x00 << 2)
#define	LCR_2_STOP_BIT			(0x01 << 2)
#define	LCR_STOP_BIT_MASK		(0x01 << 2)

#define	LCR_PARITY_DISABLED		(0x00 << 3)
#define	LCR_PARITY_ENABLED		(0x01 << 3)
#define	LCR_PARITY_ENABLE_MASK	(0x01 << 3)

#define	LCR_ODD_PARITY			(0x00 << 4)
#define	LCR_EVEN_PARITY			(0x01 << 4)
#define	LCR_MARK_PARITY			(0x02 << 4)
#define	LCR_SPACE_PARITY		(0x03 << 4)
#define	LCR_PARITY_TYPE_MASK	(0x03 << 4)

#define	LCR_BREAK_OFF			(0x00 << 6)
#define	LCR_BREAK_ON			(0x01 << 6)
#define	LCR_BREAK_MASK			(0x01 << 6)

#define	LCR_DLAB_OFF			(0x00 << 7)
#define	LCR_DLAB_ON				(0x01 << 7)
#define	LCR_DLAB_MASK			(0x01 << 7)

//	LSR register encodings

#define	LSR_DATA_READY_BIT		0x01
#define	LSR_OE_BIT				0x02
#define	LSR_PE_BIT				0x04
#define	LSR_FRAME				0x08
#define	LSR_BREAK				0x10
#define	LSR_THE_BIT				0x20
#define	LSR_TXE_BIT				0x40

//	MCR register encodings

#define	MCR_DTR_HIGH			(0x00 << 0)
#define	MCR_DTR_LOW				(0x01 << 0)
#define	MCR_DTR_MASK			(0x01 << 0)

#define	MCR_RTS_HIGH			(0x00 << 1)
#define	MCR_RTS_LOW				(0x01 << 1)
#define	MCR_RTS_MASK			(0x01 << 1)

//	MSR register encodings

#define	MSR_DCTS_BIT			0x01
#define	MSR_DDSR_BIT			0x02
#define	MSR_TERI_BIT			0x04
#define	MSR_DDCD_BIT			0x08
#define	MSR_CTS_BIT				0x10
#define	MSR_DSR_BIT				0x20
#define	MSR_RI_BIT				0x40
#define	MSR_DCD_BIT				0x80

//	IIR register encodings

#define	IIR_NONE				0x01
#define	IIR_MSR					0x00
#define	IIR_THE					0x02
#define	IIR_RX					0x04
#define	IIR_LSR					0x06
#define	IIR_MASK				0x07

//	IER register encodings

#define	IER_RX					0x01
#define	IER_TX					0x02
#define	IER_LS					0x04
#define	IER_MS					0x08

