
/*
 *	server.c
 *
 *	QNX 4
 *
 *	(C) Copyright 1997 by Robert Krten, all rights reserved.
 *
 *	This module is the main server for the X-10.
 *
 *	1997 01 11	R. Krten		created.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <signal.h>
#include <conio.h>
#include <sys/proxy.h>
#include <sys/sys_msg.h>
#include <sys/kernel.h>
#include <sys/name.h>

#include "x10.h"

extern	char	*optn;						// main.c, registered name of driver
extern	int		optp;						// main.c, base port address
extern	int		optv;						// main.c, verbosity
extern	char	*progname;					// main.c
extern	char	*version;					// version.c

extern	volatile Serial_t SerialPort;		// intr.c, info about the serial port
extern	int		proxyIRQ_PID;				// intr.c, PID of created proxy for interrupt
int				proxyTimer_PID;				// PID of created proxy for timer
timer_t			timerID;					// ID of created timer
struct sigevent	timerEvent;					// event to return from timer

// sanity -- these are used for a course timeout in case the serial port gets stuck
// (doesn't seem to happen at all ever with the new back-end non-isr poll)
int				sanityProxy;
timer_t			sanityTimerID;
struct sigevent	sanityTimerEvent;

int				replyPID;
int				shouldReply;

static	IPC_t	ipc;

void
initServer ()
{
	registerName ();
	
	if ((proxyTimer_PID = qnx_proxy_attach (0, 0, 0, 15)) == -1) {
		fprintf (stderr, "%s:  can't allocate timer proxy\n", progname);
		perror (NULL);
		exit (1);
	}

	timerEvent.sigev_signo = -proxyTimer_PID;
	if ((timerID = timer_create (CLOCK_REALTIME, &timerEvent)) == -1) {
		fprintf (stderr, "%s:  unable to allocate timer\n", progname);
		perror (NULL);
		exit (1);
	}

	if ((sanityProxy = qnx_proxy_attach (0, 0, 0, 15)) == -1) {
		fprintf (stderr, "%s:  can't allocate sanity timer proxy\n", progname);
		perror (NULL);
		exit (1);
	}
	sanityTimerEvent.sigev_signo = -sanityProxy;
	if ((sanityTimerID = timer_create (CLOCK_REALTIME, &sanityTimerEvent)) == -1) {
		fprintf (stderr, "%s:  unable to allocate timer\n", progname);
		perror (NULL);
		exit (1);
	}
}

void
serve ()
{
	struct	itimerspec	timer;
	struct	itimerspec	sanityTimer;
	int		data;
	int		phase;
	int		gotClock;		// convenience variable, derived from clock transitor
	char	txbuffer [MaxTXBufferSize];
	int		txptr;			// current byte index (represents bit #) into txbuffer
	int		txsize;			// number of bits to tx

	phase = 0;
	data = 0;
	txptr = 0;
	txsize = 0;
	for (;;) {
		replyPID = Receive (0, &ipc, sizeof (ipc));
		sanityTimer.it_value.tv_sec = 1;				// 1 s
		sanityTimer.it_value.tv_nsec = 0;
		sanityTimer.it_interval.tv_sec = 0;
		sanityTimer.it_interval.tv_nsec = 0;
		timer_settime (sanityTimerID, 0, &sanityTimer, NULL);
		if (replyPID == proxyIRQ_PID) {
			gotClock = 0;
			do {
				// printf ("[%c%c%c%c] %c%c\n",  SerialPort.msr & 0x80 ? '1' : '0', SerialPort.msr & 0x40 ? '1' : '0', SerialPort.msr & 0x20 ? '1' : '0', SerialPort.msr & 0x10 ? '1' : '0', SerialPort.msr & MSR_CLOCK_BIT ? '+' : '-', SerialPort.msr & MSR_DATA_BIT ? '1' : '0');
				if (SerialPort.msr & MSR_CLOCK_BIT) {
					if (!phase) {
						phase = 1;
						data = 0;
						gotClock = 1;
					} 
				} else {
					if (phase) {
						phase = 0;
						data = 0;
						gotClock = 1;
					}
				}
				if (!(SerialPort.msr & MSR_DATA_BIT)) {	// we have a one
					data = 1;
				}
			} while ((SerialPort.msr = inp (optp + R_MS)) & 0x0f);
			if ((txptr < txsize) && gotClock) {
				if (txbuffer [txptr] & 1) {
					set_port (optp + R_MC, MCR_RTS_MASK, MCR_RTS_LOW);
				}
			}
			timer.it_value.tv_sec = 0;
			timer.it_value.tv_nsec = 1000000;		// 1 milliseconds
			timer.it_interval.tv_sec = 0;
			timer.it_interval.tv_nsec = 0;			// non-repetetive
			timer_settime (timerID, 0, &timer, NULL);	// start it up
		} else if (replyPID == proxyTimer_PID) {
			// printf ("-> %d\n", data);
			if (txptr < txsize) {					// we were transmitting
				if (txbuffer [txptr] & 1) {			// and it was a one
					set_port (optp + R_MC, MCR_RTS_MASK, MCR_RTS_HIGH);	// turn it off
				}
				txptr++;
			}
			if (txptr >= txsize) {
				if (shouldReply) {
					Reply (shouldReply, NULL, 0);
					shouldReply = 0;
				}
			}
			decode (data);
		} else if (replyPID == sanityProxy) {
			printf ("\nsanity\n");
			printf ("Stored values:  IIR %4X MSR %4X LSR %4X RX %4X\n", SerialPort.iir, SerialPort.msr, SerialPort.lsr, SerialPort.rx);
			printf ("MSR %4X %4X\n", optp + R_MS, inp (optp + R_MS));
			printf ("MSR %4X %4X\n", optp + R_MS, inp (optp + R_MS));
			printf ("MSR %4X %4X\n", optp + R_MS, inp (optp + R_MS));
			printf ("MSR %4X %4X\n", optp + R_MS, inp (optp + R_MS));
{
	FILE *fp;
	time_t now;
	struct tm *t;

 	fp = fopen ("/usr/log/x10.log", "a");
 	if (fp != NULL) {
		time (&now);
		t = localtime (&now);
		fprintf (fp, "%04d%02d%02d %02d:%02d:%02d <event lost due to MSR bug>\n",
			t -> tm_year + 1900, t -> tm_mon + 1, t -> tm_mday, t -> tm_hour, t -> tm_min, t -> tm_sec);
		fclose (fp);
	}
}

		} else {
			switch (ipc.type) {
			case	X10_Type:
				switch (ipc.subtype) {
				case	X10_TX:
					strcpy (txbuffer, ipc.buffer);
					txptr = 0;
					txsize = strlen (txbuffer);
					shouldReply = replyPID;
					break;
				}
				break;
			default:
				break;
			}
		}
	}
}

void
registerName ()
{
	if (qnx_name_attach (0, optn) == -1) {
		fprintf (stderr, "%s:  unable to register name \"%s\", errno %d\n", progname, optn, errno);
		perror (NULL);
		exit (1);
	}
}

