
/*
 *	x10.h
 *
 *	QNX 4
 *
 *	(C) Copyright 1997 by Robert Krten, all rights reserved.
 *
 *	This module contains the manifest constants and declarations for
 *	the X-10 server.
 *
 *	1997 01 11	R. Krten		created
*/

#include "proto.h"
#include "serial.h"

typedef unsigned short U16;

/*
 *	The IPC structure
*/

#define MaxTXBufferSize	512

//	type field definitions
#define	X10_Type		0x8000

//	subtype field definitions
#define	X10_TX			1

typedef struct {
	U16		type;
	U16		subtype;
	char	buffer [MaxTXBufferSize];
}	IPC_t;

/*
 *	The serial port data structure
*/

typedef struct {
	U16		iir;
	U16		lsr;
	U16		msr;
	U16		rx;
}	Serial_t;

/*
 *	The X-10 decoder data structure
*/

typedef struct {
	time_t	when;
	char	house;
	char	keycode;
}	X10Decode_t;

/*
 *	Local conventions
*/

#define	MSR_CLOCK_BIT		MSR_CTS_BIT
#define	MSR_DATA_BIT		MSR_DCD_BIT

