// XWaveInput.cpp

#include "XWaveInput.h"

void XWaveInputSpec::Clear() {
	format.Set(kXRate22050, kXSize8bit, kXChanMono);
	mode = kGainUnavailable;
	gain = 0;
	name[0] = 0;
}

XWaveInputDevice::XWaveInputDevice()
{
	recording = false;
	processor = 0;
	procData = 0;
	curSpec.Clear();
}

XWaveInputDevice::~XWaveInputDevice()
{
	if (IsRecording())
		Stop();
}

XWaveInputError XWaveInputDevice::Start(XWaveInputSpec& wis,
										XWaveInputDataProcessor* dp,
										long x)
{
	curSpec = wis;
	processor = dp;
	procData = x;
	
	XWaveInputError result = StartRecording();
	
	if (result == kXNoError)
		recording = true;
		
	return result;
}

XWaveInputError XWaveInputDevice::Stop()
{
	recording = false;
	return StopRecording();
}

void XWaveInputDevice::HandleNewSamples(unsigned char* deviceBuffer,
										long bufLen)
{
	if (processor)
		processor->Process(deviceBuffer, bufLen, curSpec, procData);
}
