// XWaveInputMac.h
#ifndef XWAVEINPUTMAC_H
#define XWAVEINPUTMAC_H

#include "XWaveInput.h"
#include <SoundInput.h>


class XWaveInputDeviceMac : public XWaveInputDevice {

	private:

	friend pascal void MyInterruptRoutine(SPB* spb, unsigned char* buf, 
							   short peak, long bufLen);
	
	// structure for saving the Mac hardware state
	struct {
		bool saveChan;	// chan: number of channels
		short chanVal;
		bool saveComp;	// comp: compression
		long compVal;
		bool saveSsiz;	// ssiz: sample size
		short ssizVal;
		bool saveTwos;	// twos: two's complement
		short twosVal;
		bool savePlth;	// plth: playthrough
		short plthVal;
		bool saveGain;	// gain: mono variable gain
		long gainVal;
		bool saveSgai;	// sgai: stereo variable gain
		long sgaiVal[2];
		bool saveAGC;	// agc: automatic gain control
		short agcVal;
		bool saveSrat;	// srat: sample rate
		long sratVal;
		bool saveVoxr;	// voxr: VOX recording
		short voxrVal[2];
		bool saveVoxs;	// voxs: VOX stop
		short voxsVal[3];
	} snapshot;
	
	long device;
	SPB recReq;						// sound input parameter block
	
	OSErr SetMacSIHardware();
	void SaveMacSIHardware();
	void RestoreMacSIHardware();
	void PrepareMacRecordRequest();
	
	public:
	XWaveInputDeviceMac();
	~XWaveInputDeviceMac();
	
	XWaveInputError StartRecording();
	XWaveInputError StopRecording();
	
	bool HardwareAvailable(XWaveInputSpec& spec);
};

#endif
