// XWaveInputWin.h
#ifndef XWAVEINPUTWIN_H
#define XWAVEINPUTWIN_H

#include "XWaveInput.h"
#include "InputBuffer.h"

class XWaveInputDeviceWindows : public XWaveInputDevice {

	private:
	enum { kBufferCount = 64 };
	HWND privateWindow;
	HWAVEIN device;
	InputBuffer* bufferList[kBufferCount];
	
	bool ErrorSuggestsBusyDevice(MMRESULT err);
	MMRESULT TryToOpenWaveInDevice(int devIndex, WAVEFORMATEX& wf,
					DWORD callbackObject, DWORD callbackObjectType);
	void ConvertXWaveInSpecToWindows(XWaveInputSpec& wis,
									 WAVEFORMATEX& wfx);
	void PrepareBuffers();
	void UnprepareBuffers();
	void ProcessBufferData(InputBuffer* ib);
	void RecycleBuffer(InputBuffer* ib);
	
	public:
	XWaveInputDeviceWindows();
	~XWaveInputDeviceWindows();
	
	XWaveInputError StartRecording();
	XWaveInputError StopRecording();
	
	bool HardwareAvailable(XWaveInputSpec& spec);

	void ProcessRecycleBufferMessage(LPARAM lParam);
};

// you must call this to properly initialize the system
void InitXWaveInputWindows(HINSTANCE h);

#endif
