// Listing 3a: InputBuffer.h (monospaced, tabs every 4 spaces)
// A class for abstracting and managing input buffers on Windows.
// by Randall Cook
// Copyright (C) 1998 Randall Cook. All Rights Reserved.

#ifndef INPUTBUFFER_H
#define INPUTBUFFER_H

#include <mmsystem.h>

class InputBuffer {
    enum InputBlockState {
        kNotAvailable,	// not available for use (could not allocate
        				// blockHandle)
        kAllocated,		// blockHandle is valid
        kLocked,		// blockPtr is valid
        kPrepared		// header is in the device queue
    };

    HANDLE blockHandle;			// handle to the data buffer
	unsigned char* blockPtr;	// pointer to the data buffer
	WAVEHDR header;				// the Windows header structure
	InputBlockState state;		// the state of the buffer
    HWAVEIN device;				// the device that is filling the 
    							// buffer, or zero when not recording
    
    void Lock();
    void Unlock();

	public:
	InputBuffer(int bufSize);
	~InputBuffer();
	void Prepare(HWAVEIN device);
    void Unprepare();
    
    unsigned char* GetData() { return blockPtr; }
    long GetDataLen() { return header.dwBytesRecorded; }
	bool ContainsValidData();
};

#endif