// Listing 2a: WindowsRecorder.h (monospaced, tabs every 4 spaces)
// A class for recording continuously on Windows.
// by Randall Cook
// Copyright (C) 1998 Randall Cook. All Rights Reserved.

#ifndef WINDOWSRECORDER_H
#define WINDOWSRECORDER_H

#include <mmsystem.h>
#include "InputBuffer.h"

// interface for sample processing class
class SampleProcessor {
	public:
	virtual void ProcessSamples(unsigned char* buffer, long length) = 0;
};

// the sound recording class
class WindowsRecorder {
	friend void CALLBACK MyInterruptRoutine(HWAVEIN hwi, UINT uMsg, 
				DWORD dwInstance, DWORD dwParam1, DWORD dwParam2);
	
	private:
	HWND hostWindow;			// the window that gets the recycle messages
	HWAVEIN device;				// the wave input device
	bool recording;				// a flag indicating recording status
	bool useInterruptRoutine;	// a flag indicating recording mode
	InputBuffer** bufferList;	// an array of InputBuffer*
	int bufferCount;			// number of buffers in bufferList
	UINT recycleBufferMessage;	// the recycle buffer message
	SampleProcessor* processor;	// an object that can process samples
	
	bool ErrorSuggestsBusyDevice(MMRESULT err);
	MMRESULT TryToOpenWaveInDevice(int devIndex, WAVEFORMATEX& wf,
					DWORD callbackObject, DWORD callbackObjectType);
	void PrepareBuffers();
	void UnprepareBuffers();
	void ProcessBufferData(InputBuffer* ib);
	void RecycleBuffer(InputBuffer* ib);
	
	protected:
	void SetRecordingParameters(WAVEFORMATEX& wf);
	
	public:
	WindowsRecorder(int bufCount, int bufSize, SampleProcessor* sp,
					HWND host);
	~WindowsRecorder();
	MMRESULT Start(bool interrupt);
	void Stop();
	bool IsRecycleBufferMessage(UINT message);
	LRESULT ProcessRecycleBufferMessage(LPARAM lParam);
	bool IsRecording() { return recording; }
};

#endif
