// Listing 5 (monospaced, tabs every 4 spaces)
// A simple but slow clipping fix algorithm.
// by Randall Cook
// Copyright (C) 1998 Randall Cook. All Rights Reserved.

// Fixes nSamples 16 bit samples at data in place. clipState is the 
// result of the last call, or 1 to initialize. lastSample is the 
// result of the last call, or *data to initialize. Assumes 32 bit
// integers.
void SlowFixClip16(int& clipState, short* data, int& lastSample, 
				   int nSamples)
{
	const long kClipThreshold = 35000;
	
	while (nSamples--) {
		int curSample = *data;
		int diff = abs(curSample - lastSample);
		
		if (diff > kClipThreshold)
			clipState = -clipState;
		
		if (clipState == -1)
			curSample = -curSample;
		
		if (curSample > 32767)	// if -32768 -> 32768
			curSample = 32767;	// make it 32767
		
		*data++ = curSample;
		lastSample = curSample;
	}
}
