/*
 * This file has been automatically generated by the webMethods Automation
 * Toolkit(TM). It is recommended that you subclass it, rather than modifying the
 * code herein.
 *
 * The webMethods Automation Toolkit is  Copyright 1997, webMethods, Inc.
 */

import java.io.*;
import watt.api.*;
import java.awt.*;
import java.util.*;
import java.applet.*;

class QuoteStockPriceServiceFieldPanel extends Panel
{
    Vector fieldVector;
    Vector labelVector;
    Panel left;
    Panel right;
    int tfNum = 0;
    int currentTfNum = 0;
    boolean panelEditable;

    QuoteStockPriceServiceFieldPanel()
    {
        fieldVector = new Vector();
        labelVector = new Vector();
    }

    String getWidestLabelText()
    {
        int width = 0;
        int index = 0;
        int i;
        for(i = 0; i < labelVector.size(); i++)
        {
            if(((Label)labelVector.elementAt(i)).getText().length()>width)
            {
            	width=((Label)labelVector.elementAt(i)).getText().length();
            	index=i;
            }
        }
        if (labelVector.size() > 0)
        	return ((Label)labelVector.elementAt(index)).getText();
        else
            return "";
    }

    void fixWidth(String s)
    {
        int i;
        labelVector.addElement(new Label(s));
        ((Label)labelVector.lastElement()).hide();
        fieldVector.addElement(new NumberedTextField(tfNum++, 25));
        ((NumberedTextField)fieldVector.lastElement()).hide();
    }

    NumberedTextField addField(String label, boolean editable)
    {
        NumberedTextField t;
        panelEditable = editable;

        labelVector.addElement(new Label(label));
        t = new NumberedTextField(tfNum++, 25);
        t.setEditable(editable);
        if(editable)
            t.setBackground(Color.white);
        else
            t.setBackground(Color.lightGray);
        fieldVector.addElement(t);
        return (NumberedTextField)fieldVector.lastElement();
    }

    public boolean keyDown(Event e, int key)
    {
        if ((key == 9) && (panelEditable))             // TAB Key
        {
            currentTfNum = (currentTfNum + 1) % fieldVector.size();
            ((NumberedTextField)fieldVector.elementAt(currentTfNum)).requestFocus();
            return true;
        }
        else
            return super.keyDown(e, key);
    }

    void drawPanel()
    {
        int i;
        left = new Panel();
        left.setLayout(new GridLayout(0, 1));
        right = new Panel();
        right.setLayout(new GridLayout(0, 1));
        this.add("West", left);
        this.add("East", right);
        for(i = 0; i < labelVector.size(); i++)
        {
            this.left.add((Label)labelVector.elementAt(i));
            this.right.add((NumberedTextField)fieldVector.elementAt(i));
        }
    }
}

class NumberedTextField extends TextField
{
    int num;

    public NumberedTextField(int num)
    {
        super();
        this.num = num;
    }
    public NumberedTextField(int num, int numCols)
    {
        super(numCols);
        this.num = num;
    }
    public NumberedTextField(int num, String str)
    {
        super(str);
        this.num = num;
    }
    public NumberedTextField(int num, String str, int numCols)
    {
        super(str, numCols);
        this.num = num;
    }

    public int getNum()
    {
        return num;
    }
}


class QuoteStockPriceServicePanel extends QuoteStockPriceServiceFieldPanel
{
    Context context;
    QuoteStockPriceServiceFieldPanel in;
    QuoteStockPriceServiceFieldPanel out;
    Panel buttons;

    Button submit_button;
    Button clear_button;
    Label statusLabel;

    NumberedTextField t;

    String StockSymbol;

    QuoteStockPriceServicePanel()
    {
        String server = null;
        int i, width;
        this.context = context;
        in = new QuoteStockPriceServiceFieldPanel();
        out = new QuoteStockPriceServiceFieldPanel();

        Panel bPanel = new Panel();
        buttons = new Panel();
        Panel status = new Panel();

        this.setLayout(new BorderLayout());
        buttons.setLayout(new GridLayout(1,2, 20, 5));
        bPanel.setLayout(new BorderLayout(0, 5));
        status.setLayout(new BorderLayout());

        in.addField("StockSymbol",true);

        out.addField("StockPrice",false);

        String labelText=new String("");
        if(out.getWidestLabelText().length() > in.getWidestLabelText().length())
            labelText=new String(out.getWidestLabelText());
        else if(out.getWidestLabelText().length() <= in.getWidestLabelText().length())
            labelText=new String(in.getWidestLabelText());

        in.fixWidth(labelText);
        out.fixWidth(labelText);

        in.drawPanel();
        out.drawPanel();

        this.add("North",in);
        this.add("Center",out);

        submit_button=new Button("Submit");
        submit_button.setForeground(Color.black);
        submit_button.setBackground(Color.lightGray);

        clear_button=new Button("Clear");
        clear_button.setForeground(Color.black);
        clear_button.setBackground(Color.lightGray);

        buttons.add(submit_button);
        buttons.add(clear_button);

        statusLabel = new Label("");
        Font font = new Font("Helvetica", Font.ITALIC, 11);
        statusLabel.setFont(font);
        status.add("North", statusLabel);

        bPanel.add("North", buttons);
        bPanel.add("South", status);

        this.add("South",bPanel);

        context = new Context(true);
        try {
            //
            // Connect to server
            //
            server = Config.getServer();
            if (server == null)
                server = "localhost:5555";
            context.connect(server, null, null);

        } catch (WattException e) {
            if (!Config.isApplet())
            {
              System.out.println("\n\tUnable to connect to server \"" + server + "\"");
              System.exit(0);
            }
            else
                statusLabel.setText("Unable to connect to server \"" + server + "\"");
        }
    }

    public boolean keyDown(Event e, int key)
    {
        if (key == '\n') {
	    	submit();
            return true;
        }
        else
            return super.keyDown(e, key);
    }

    public Insets insets()
    {
        return new Insets(15,15,15,15);
    }

    public boolean action(Event event, Object arg)
    {
        int i;
    	if(event.target == submit_button)
    	{
    	    submit();
    	}
    	else if(event.target == clear_button)
    	{
            for(i = 0; i < in.fieldVector.size(); i++)
                ((NumberedTextField)in.fieldVector.elementAt(i)).setText(" ");
            for(i = 0; i < out.fieldVector.size(); i++)
                ((NumberedTextField)out.fieldVector.elementAt(i)).setText(" ");
    	}
    	return true;
    }

    public void submit()
    {
        statusLabel.setText("Retrieving Information. Please Wait ...");

        try
        {
            int i = 0;
            StockSymbol = ((NumberedTextField)in.fieldVector.elementAt(i++)).getText();

            if (context.getInterface("Quote") == null)
            {
                if (Config.isApplet())
                {
                    String codeBase = ((Applet)this.getParent()).getCodeBase().toString();
                    if (codeBase.indexOf("file:/") != -1)
                        codeBase = codeBase.substring(5, codeBase.length());
                    context.loadDocument(codeBase + "Quote.widl");
                }
                else
                    context.loadDocument("Quote.widl");
            }

            QuoteStockPriceService serviceClass = new QuoteStockPriceService(
                                    context,
                                    StockSymbol
                                 );
            i = 0;
            ((NumberedTextField)out.fieldVector.elementAt(i++)).setText(serviceClass.StockPrice);
            statusLabel.setText("Done.");
        }
        catch (IOException e)
        {
            statusLabel.setText("IO Exception: " + e.getMessage());
        }
        catch (WattServiceException e)
        {
            statusLabel.setText(e.getMessage());
        }
        catch (WattException e)
        {
            statusLabel.setText(e.getMessage());
        }
    }
}

public class QuoteStockPriceServiceApplet extends Applet
{
    QuoteStockPriceServicePanel p;

    public void init()
    {
        Config.appletSetup(this);

        p = new QuoteStockPriceServicePanel();
        this.add("Center",p);
        this.show();
    }

    public void destroy()
    {
        try {
            p.context.disconnect();
        } catch (WattException e) {}
        super.destroy();
    }

    public static void main(String args[])
    {
        Config.processCmdLine(args); // Server specified here

        Frame f = new Frame();
        f.resize(370, 170 + 30);
        QuoteStockPriceServicePanel p = new QuoteStockPriceServicePanel();
        f.add("Center",p);
        f.show();
    }
}

