import java.io.*;
import java.lang.reflect.*;
import java.util.Hashtable;

public class Container extends ClassLoader
{
	private Hashtable ht = new Hashtable();
	static Method m_decryptor = null;
	static Method m_main = null;
									   
	public static void main( String[] args )
	{
		Container t = new Container();
		if ( t.loadMe() == true )
		{
			try
			{
				if ( Container.m_main != null )
				{
					Container.m_main.invoke( null, new Object[] { args } );
				} else
				{
					System.out.println ( "main undefined" );
				}
			} catch ( Exception e )
			{
				System.out.println ( "Exception " + e.getMessage() );
			}
		}
	}
	
	public Class loadClass ( String name, boolean verify ) throws ClassNotFoundException
	{
		System.out.println ( "loading " + name );
		Class c = null;
		c = (Class)ht.get( name );
		if( c == null )
		{
			c = this.findSystemClass( name );
			if ( c != null )
			{
				ht.put( name, c );
			}
		}
		if ( ( c != null ) && ( verify ) )
		{
			this.resolveClass( c );
		}
		return c;
	}
	
	public boolean loadMe ( )
	{
		try
		{
			RandomAccessFile inFile = new RandomAccessFile ( this.getClass().getName() + ".class", "r" );
			
			// go to the end of the file and read in the attribute offset marker
			long eof = inFile.length();
			inFile.seek ( eof - 15 );
			
			// read the custom attribute so that we can decode class data attributes
			int customAttributeIndex = inFile.readUnsignedShort();
			int length = inFile.readInt(); // length of current attribute
			byte dataType = inFile.readByte(); // 0 = class data, 1 = Attribute offset record
			long attributesOffset = inFile.readLong(); // Beginning offset of attribute table
			
			inFile.seek( attributesOffset );
			
			int attributeCount = inFile.readUnsignedShort();
			
			// iterate through the attribute table
			ByteArrayOutputStream bout = new ByteArrayOutputStream();
			for ( int i = 0; i < attributeCount; i++ )
			{
				int attributeIndex = inFile.readUnsignedShort();
				int attributeLength = inFile.readInt();
				if ( attributeIndex == customAttributeIndex )
				{
					if ( inFile.readByte() == 0 ) // 0 = class data header
					{
						//System.out.println ( "Found custom attribute\n\tLength = " + attributeLength );				
						byte[] buffer = new byte[ attributeLength ];
						inFile.read( buffer );
						bout.write( buffer );
					} else
					{
						// attribute offset record, skip all data
						inFile.skipBytes( attributeLength - 1 );
					}
				} else
				{
					// normal attribute, just skip it
					inFile.skipBytes( attributeLength );
				}
			}
			// take resulting class data array, parse and load it into the VM.
			loadClasses( bout.toByteArray() );
		} catch ( IOException e )
		{
			System.out.println ( "Screwed up somewhere!" );
			return false;
		}
		return true;
	}
	
	public boolean loadClasses( byte[] classBytes )
	{
		ByteArrayInputStream bin = new ByteArrayInputStream ( classBytes );
		DataInputStream in = new DataInputStream ( bin );
		
		
		try
		{
			while ( in.available() > 1 )
			{
				int type = -1;
				try
				{
					// class type
					// 0 = normal class
					// 1 = decryptor class
					// 2 = main/executable class
					type = in.readByte();
				} catch ( IOException e )
				{
				}
				
				int length = in.readInt(); // length of class file data
				
				byte[] bytes = new byte[ length ];
				in.read ( bytes ); // loads class file into array
				
				// if a decryptor is set, decode the data
				if ( m_decryptor != null )
				{
					try
					{
						bytes = (byte[])this.m_decryptor.invoke( null, new Object[] { bytes } );
					} catch ( Exception e )
					{
						e.printStackTrace();
					}
				}
				
				// define and resolve the class
				Class c = defineClass( null, bytes, 0, bytes.length );
				resolveClass ( c );
				
				switch ( type )
				{
				case 1: // crypto class
					try
					{
						System.out.println ( "***Container " + c.getName() );
						
						// find static decryptor method.
						// All Container.class derivations MUST implement a static decryptor
						m_decryptor = c.getDeclaredMethod( "decrypt", new Class[] { byte[].class } );
						
					} catch ( Throwable t )
					{
						t.printStackTrace();
						System.out.println ( "New container " + c.getName() + " failed to load as a decryptor" );
						return false;
					}
					break;
				case 2: // main
					try
					{
						System.out.println ( "found a main" );
						m_main = c.getDeclaredMethod( "main", new Class[] { String[].class } );
						System.out.println ( m_main );
					} catch ( Exception e )
					{
						System.out.println ( "Class " + c.getName() + " does not have a main" );
						return false;
					}
					break;
				}
			}
		} catch (IOException ioe )
		{
			System.out.println ( "IOException occured while breaking down class files" );
			return false;
		}
		return true;
		
	}
	
	public static byte[] encrypt( byte[] value )
	{
		System.out.println ( "Container.encrypt() " + value.length );
		return value;
	}
	
	public static byte[] decrypt( byte[] value )
	{
		return value;
	}
}
