
package dph.awt.lightweight;

import java.awt.*;
import java.awt.event.*;


public class DoubleBufferedFrame extends Frame {
    Image offScrImg;
    
    
    public DoubleBufferedFrame( String title ) {
        super( title );
    }
    
    
    public void invalidate() {
        super.invalidate();
        offScrImg = null;
    }

    
    public void update( Graphics g ) {
        paint( g );
    }
    
    
    public void paint( Graphics g ) {
        if( offScrImg == null  &&  g != null )
            offScrImg = this.createImage( this.getSize().width, this.getSize().height );
        if( offScrImg == null )
            return;
        Graphics bufferedG = offScrImg.getGraphics();    
        bufferedG.setColor( this.getBackground() );
        bufferedG.fillRect( 0, 0, this.getSize().width, this.getSize().height );
        super.paint( bufferedG );
        g.drawImage( offScrImg, 0, 0, null );
        bufferedG.dispose();
    }
    
}