
package dph.awt.lightweight;

import java.awt.*;
import java.awt.event.*;


public class RoundButton extends ButtonBase {


    // -----[ Constructors ]-----
    public RoundButton() {
        this("");
    }


    public RoundButton( String label ) {
        super( label );
    }



	/**
	 * Gets the optimum size for this RoundButton, which will be calculated to encompass
	 * any title and image with a few pixels extra on all four sides.
	 */
	protected java.awt.Dimension figureMySize( java.awt.Graphics g ) {
        Font f = getFont();
        if( f != null ) {
            FontMetrics fm = getFontMetrics( f );
            int max = Math.max( fm.stringWidth(label)+10, fm.getHeight()+10 );
            return new Dimension( max, max );
        } 
        return new Dimension( 100, 100 );
	}
	


    // -----[ Determine if click was inside round button ] -----
    public boolean contains( int x, int y ) {
        int radius_x = getSize().width/2;       
        int radius_y = getSize().height/2;       
        return (((radius_x-x)*(radius_x-x) + (radius_y-y)*(radius_y-y)) <= radius_x*radius_x);   
    }

  
    // ----[ Handle Events ]-----
    public void processMouseEvent( MouseEvent me ) {
        if( isEnabled() ) {
            switch( me.getID() ) {
                case MouseEvent.MOUSE_PRESSED:
                    pressed = true;
                    repaint();
                    break;
                case MouseEvent.MOUSE_RELEASED:
                    if( pressed == true ) {
                        pressed = false;
                        repaint();
                    }
                    break;
                case MouseEvent.MOUSE_ENTERED:
                    break;
                case MouseEvent.MOUSE_EXITED:
                    if( pressed == true ) {
                        pressed = false;
                        repaint();
                    }
                    break;
            }
        }
        super.processMouseEvent( me );
    }


    // -----[ Draw the button to the screen ]-----
    public void paint( Graphics g ) {
        int diameter = Math.min( getSize().width, getSize().height );

        // paint rim;
        g.setColor( Color.black );
        g.fillOval( 0, 0, diameter, diameter );
        
        // paint interior
        if( pressed ) {
            g.setColor( getBackground().darker() );
        } else {
            g.setColor( getBackground() );
        }
        g.fillOval( 1, 1, diameter-3, diameter-3 );

        // draw the label
        Font f = getFont();
        if( f != null ) {
            FontMetrics fm = getFontMetrics( f );
            if( isEnabled() ) {
                if( pressed )
                    g.setColor( getForeground().darker() );
                else    
                    g.setColor( getForeground() );
            }
            else
                g.setColor( java.awt.Color.gray );
            g.drawString( label, (diameter/2 - fm.stringWidth(label)/2)-1, diameter/2 + fm.getMaxDescent() );
        }
    }


    // -----[ Unit Test ]-----
    public static void main( String[] args ) {
        Frame f = new Frame( "Test DphDoubleBufferPanel extends Panel" );
        f.setSize( 560, 400 );
        Panel p = new DoubleBufferedPanel();
        p.setBackground( Color.yellow );
        RoundButton btn = new RoundButton( "Exit" );
        RoundButton btn2 = new RoundButton( "Don't Exit" );
        btn.setBackground( Color.cyan );
        btn2.setBackground( Color.yellow );
        btn.addActionListener( new ActionListener() {
            public void actionPerformed( ActionEvent evt ) {
                System.out.println( "Action Performed in " + evt.getSource() + " with command of " + evt.getActionCommand() );
                System.exit( 0 );
            }
        });

        p.add( btn );
        p.add( btn2 );
        f.add( "Center", p );
        f.setVisible( true );
    }
}
