
package dph.play.alarmclock;

import dph.awt.lightweight.*;

public final class AlarmClockFrame extends DoubleBufferedExitingFrame {
    
     TabPanel tabPanel;
     Checkbox ringAlarmCheckbox;
     Checkbox ampmTimeCheckbox, ampmAlarmCheckbox;
     Checkbox anyDayCB, mondayCB, tuesdayCB, wednesdayCB;
     Checkbox thursdayCB, fridayCB, saturdayCB, sundayCB;
     FlatButton setTimeBtn = new FlatButton( "Set Time" );
     FlatButton setSysTimeBtn = new FlatButton( "Reset to System Time" );
     Spinner timeHourSpinner, alarmHourSpinner;
     Spinner timeMinuteSpinner, alarmMinuteSpinner;
     TimeSpinnerHandler timeSpinHandler;
     DoubleBufferedPanel timePanel, alarmPanel;
     ClockCanvas clock;
    
     java.util.Vector alarmDays = new java.util.Vector();
     java.util.Calendar date = java.util.Calendar.getInstance();
     boolean allDaysLoaded;
     boolean timeIsPM;
     boolean alarmIsPM;
    
    
    
    public AlarmClockFrame( String title ) {
        super( title );
		setBackground( new java.awt.Color(-5203068) );
		setLayout( null );
        setSize( 510, 620 );
        
	    add( clock = new ClockCanvas() );
	    clock.setBounds( 130, 50, 250, 260 );
	    clock.setVisible( true );
	    clock.setAlarmClockFrame( this );
        
		
		tabPanel = new TabPanel();
		tabPanel.setBackground( new java.awt.Color(-5203068) );
		tabPanel.setSize( 460, 250 );
		
		timeSpinHandler = new TimeSpinnerHandler( setTimeBtn );
		
		this.setupTimePanel();
		this.setupAlarmPanel();
		
		tabPanel.addTabPanel( "Time", timePanel );
		tabPanel.addTabPanel( "Alarm", alarmPanel );
		add( tabPanel );
		tabPanel.setLocation( 20, 320 ); 
		//tabPanel.setSelectedTab( 0 );
		this.setTimeInWidgets();
		
		setTimeBtn.setEnabled( false );
    }
    
    
    
    public void setupTimePanel() {
        timePanel = new DoubleBufferedPanel();
		timePanel.setBackground( new java.awt.Color(-5203068) );
        timePanel.setLayout( null );
        
        timePanel.add( setTimeBtn );
        setTimeBtn.setLocation( 105, 100 );
        setTimeBtn.setSize( 164, 22 );
		setTimeBtn.addActionListener( new java.awt.event.ActionListener() {
		    public void actionPerformed( java.awt.event.ActionEvent evt ) {
		        setTimeFromWidgets();
                setTimeBtn.setEnabled( false );
		    }
		});
        
        
        timePanel.add( setSysTimeBtn );
        setSysTimeBtn.setLocation( 105, 160 );
        setSysTimeBtn.setSize( 164, 22 );
        setSysTimeBtn.addActionListener( new SysTimeBtnHandler() );
        
        timeHourSpinner = new Spinner();
        timeHourSpinner.setRollsOver( true );
        timeHourSpinner.setMinValue( 1 );
        timeHourSpinner.setMaxValue( 12 );
        timePanel.add( timeHourSpinner );
        timeHourSpinner.setLocation( 105, 50 );
        
        Label hourLabel = new Label( "Hour" );
        timePanel.add( hourLabel );
        hourLabel.setLocation( 110, 25 );
        
        timeMinuteSpinner = new Spinner();
        timeMinuteSpinner.setRollsOver( true );
        timeMinuteSpinner.setMinValue( 1 );
        timeMinuteSpinner.setMaxValue( 60 );
        timePanel.add( timeMinuteSpinner );
        timeMinuteSpinner.setLocation( 165, 50 );
        
        timeMinuteSpinner.addActionListener( timeSpinHandler );
        timeHourSpinner.addActionListener( timeSpinHandler );

        Label minuteLabel = new Label( "Minute" );
        timePanel.add( minuteLabel );
        minuteLabel.setLocation( 165, 25 );
        
        ampmTimeCheckbox = new Checkbox( "PM" );
        timePanel.add( ampmTimeCheckbox );
        ampmTimeCheckbox.setLocation( 220, 53 );
        
        Label ampmLabel = new Label( "AM/PM" );
        timePanel.add( ampmLabel );
        ampmLabel.setLocation( 226, 25 );
    }
    
    
	public void setTimeInWidgets() {
	    timeIsPM =  date.get(java.util.Calendar.AM_PM) == 1;
	    ampmTimeCheckbox.setState( timeIsPM );
	    int hour = date.get( java.util.Calendar.HOUR );
	    int min = date.get( java.util.Calendar.MINUTE );
	    clock.setTime( hour, min, timeIsPM );
        timeMinuteSpinner.setValue( min );
        timeHourSpinner.setValue( hour == 0 ? 12 : hour );
        setTimeBtn.setEnabled( false );
        repaint();
	}
	
	
	public void setTimeFromWidgets() {
        int min = timeMinuteSpinner.getValue();
        int hour = timeHourSpinner.getValue();
        timeIsPM = ampmTimeCheckbox.getState();
        clock.setTime( hour, min, timeIsPM );    
	}
	
	
	public void setMinuteInTimeSpinner( int minute ) {
        timeMinuteSpinner.setValue( minute );
	}
	
	public void setHourInTimeSpinner( int hour ) {
        timeHourSpinner.setValue( hour );
	}
	
    
    public void setupAlarmPanel() {
        alarmPanel = new DoubleBufferedPanel();
		alarmPanel.setBackground( new java.awt.Color(-5203068) );
        alarmPanel.setLayout( null );
        
        ringAlarmCheckbox = new Checkbox( "Alarm On" );
        alarmPanel.add( ringAlarmCheckbox );
        ringAlarmCheckbox.setLocation( 300, 53 );
        ringAlarmCheckbox.addItemListener( new java.awt.event.ItemListener() {
            public void itemStateChanged( java.awt.event.ItemEvent evt ) {
                Checkbox cb = (Checkbox) evt.getSource();
                if( cb.getState() ) {
    		        int min = alarmMinuteSpinner.getValue();
    		        int hour = alarmHourSpinner.getValue();
    		        alarmIsPM = ampmAlarmCheckbox.getState();
    		        clock.setAlarm( hour, min, alarmIsPM );    
		        }
            }
        });
        
        alarmHourSpinner = new Spinner();
        alarmHourSpinner.setRollsOver( true );
        alarmHourSpinner.setMinValue( 1 );
        alarmHourSpinner.setMaxValue( 12 );
        alarmHourSpinner.setValue( 12 );
        alarmPanel.add( alarmHourSpinner );
        alarmHourSpinner.setLocation( 105, 50 );
        
        Label hourLabel = new Label( "Hour" );
        alarmPanel.add( hourLabel );
        hourLabel.setLocation( 110, 25 );
        
        alarmMinuteSpinner = new Spinner();
        alarmMinuteSpinner.setRollsOver( true );
        alarmMinuteSpinner.setMinValue( 1 );
        alarmMinuteSpinner.setMaxValue( 60 );
        alarmPanel.add( alarmMinuteSpinner );
        alarmMinuteSpinner.setLocation( 165, 50 );
        
        Label minuteLabel = new Label( "Minute" );
        alarmPanel.add( minuteLabel );
        minuteLabel.setLocation( 165, 25 );
        
        ampmAlarmCheckbox = new Checkbox( "PM" );
        alarmPanel.add( ampmAlarmCheckbox );
        ampmAlarmCheckbox.setLocation( 220, 53 );
        
        Label ampmLabel = new Label( "AM/PM" );
        alarmPanel.add( ampmLabel );
        ampmLabel.setLocation( 226, 25 );
 
        
        // Setup the checkboxes for which days to ring alarm on
        anyDayCB = new Checkbox( "Any Day" );
        mondayCB = new Checkbox( "Mon" );
        tuesdayCB = new Checkbox( "Tue" );
        wednesdayCB = new Checkbox( "Wed" );
        thursdayCB = new Checkbox( "Thu" );
        fridayCB = new Checkbox( "Fri" );
        saturdayCB = new Checkbox( "Sat" );
        sundayCB = new Checkbox( "Sun" );
        
        Label daysLabel = new Label( "Days to Ring Alarm" );
        alarmPanel.add( daysLabel );
        daysLabel.setLocation( 15, 115 );
        
        alarmPanel.add( anyDayCB );
        anyDayCB.setLocation( 15, 140 );
        alarmPanel.add( mondayCB );
        mondayCB.setLocation( 15, 180 );
        alarmPanel.add( tuesdayCB );
        tuesdayCB.setLocation( 75, 180 );
        alarmPanel.add( wednesdayCB );
        wednesdayCB.setLocation( 135, 180 );
        alarmPanel.add( thursdayCB );
        thursdayCB.setLocation( 199, 180 );
        alarmPanel.add( fridayCB );
        fridayCB.setLocation( 259, 180 );
        alarmPanel.add( saturdayCB );
        saturdayCB.setLocation( 315, 180 );
        alarmPanel.add( sundayCB );
        sundayCB.setLocation( 375, 180 );

        
        // Create an instance of the checkbox handler and add it as
        // listener for each day checkbox
        DayCheckboxHandler dayCBHandler = new DayCheckboxHandler();
 
        anyDayCB.addItemListener( dayCBHandler );
        mondayCB.addItemListener( dayCBHandler );
        tuesdayCB.addItemListener( dayCBHandler );
        wednesdayCB.addItemListener( dayCBHandler );
        thursdayCB.addItemListener( dayCBHandler );
        fridayCB.addItemListener( dayCBHandler );
        saturdayCB.addItemListener( dayCBHandler );
        sundayCB.addItemListener( dayCBHandler );
    }
    
    
	public void setTimeBtnState( boolean state ) {
	    setTimeBtn.setEnabled( state );
	}
	
	

    
    public void ringAlarm() {
        class RingThread extends Thread {
            java.awt.Toolkit tk = java.awt.Toolkit.getDefaultToolkit();
            int count = 0;
            public void run() {
                if( ringAlarmCheckbox.getState() ) {
                    try {
                        while( ringAlarmCheckbox.getState() ) {
                            tk.beep();
                            System.out.println( "ring" );
                            ++count;
                            if( count > 120 )
                                break;
                            else    
                                Thread.sleep( 500 );
                        }
                    } catch( InterruptedException ex ) {
                        // ignore it
                    }
                }
            }
        }
        
        RingThread thread = new RingThread();
        thread.setPriority( Thread.MIN_PRIORITY );
        thread.start();
    }
    
    
    
    // Nested action handler class to set system time into widgets
    public class SysTimeBtnHandler implements java.awt.event.ActionListener {
        public void actionPerformed( java.awt.event.ActionEvent evt ) {
            setTimeInWidgets();
        }
    }



	// Nested class for hooking spinners with setTimeBtn
	public class TimeSpinnerHandler implements java.awt.event.ActionListener {
	    ButtonBase btn;
	    TimeSpinnerHandler( ButtonBase btn ) {
	        this.btn = btn;
	    }
	    
	    public void actionPerformed( java.awt.event.ActionEvent evt ) {
	        btn.setEnabled( true );
	    }
	}

    
    // Nested class to handle adding days to vector
    public class DayCheckboxHandler implements java.awt.event.ItemListener {
        public void itemStateChanged( java.awt.event.ItemEvent evt ) {
            Checkbox cb = (Checkbox)evt.getSource();
            String label = cb.getLabel();
            Integer day = null;
            if( label.equalsIgnoreCase( "Mon" ) )
                day = new Integer( 2 );
            else if( label.equalsIgnoreCase( "Tue" ) )
                day = new Integer( 3 );
            else if( label.equalsIgnoreCase( "Wed" ) )
                day = new Integer( 4 );
            else if( label.equalsIgnoreCase( "Thu" ) )
                day = new Integer( 5 );
            else if( label.equalsIgnoreCase( "Fri" ) )
                day = new Integer( 6 );
            else if( label.equalsIgnoreCase( "Sat" ) )
                day = new Integer( 7 );
            else if( label.equalsIgnoreCase( "Sun" ) )
                day = new Integer( 1 );
            else if( label.equalsIgnoreCase( "Any Day" ) ) {
                alarmDays.removeAllElements();
                if( !allDaysLoaded ) {
                    alarmDays.addElement( day = new Integer(1) );
                    alarmDays.addElement( day = new Integer(2) );
                    alarmDays.addElement( day = new Integer(3) );
                    alarmDays.addElement( day = new Integer(4) );
                    alarmDays.addElement( day = new Integer(5) );
                    alarmDays.addElement( day = new Integer(6) );
                    alarmDays.addElement( day = new Integer(7) );
                    mondayCB.setState( true );
                    tuesdayCB.setState( true );
                    wednesdayCB.setState( true );
                    thursdayCB.setState( true );
                    fridayCB.setState( true );
                    saturdayCB.setState( true );
                    sundayCB.setState( true );
                    allDaysLoaded = true;
                }
                else {
                    mondayCB.setState( false );
                    tuesdayCB.setState( false );
                    wednesdayCB.setState( false );
                    thursdayCB.setState( false );
                    fridayCB.setState( false );
                    saturdayCB.setState( false );
                    sundayCB.setState( false );
                    allDaysLoaded = false;
                }
            }
             
            if( cb != anyDayCB  &&  allDaysLoaded ) {
                anyDayCB.setState( false );
                allDaysLoaded = false;
            }
            
            if( day != null  ) {    
                if( cb.getState() ) {
                    if( !alarmDays.contains( day ) ) {
                        alarmDays.addElement( day );
                    }
                }    
                else{
                    if( alarmDays.contains( day ) ) {
                        alarmDays.removeElement( day );
                    }
                }
                clock.setAlarmDays( alarmDays );
            }
        }
    }
    
    
    public static void main( String[] args ) {
        AlarmClockFrame frame = new AlarmClockFrame( "Lightweight Alarm Clock" );
        frame.setResizable( false );
        frame.setVisible( true );
    }
}