
package dph.play.alarmclock;


public final class ClockCanvas extends java.awt.Component {
	private AlarmClockFrame alarmClock;
	private java.awt.Dimension mSize;
	private java.awt.Image buffer;
	private java.awt.Graphics bufferG;
	private SecondsThread secondsThread;
	private int hour = -1, min = -1;
    private int alarmHour = -1, alarmMinute = -1;
    private boolean timeIsPM, alarmIsPM;
    private java.util.Vector alarmDays;


	public ClockCanvas() {
		setBackground( new java.awt.Color(-5203068) );
		setForeground( java.awt.Color.red );
	}


	public void addNotify() {
		super.addNotify();
		mSize = this.getSize();
	    if( buffer == null  &&  mSize != null ) {
	        this.createBuffer( mSize.width, mSize.height );
	        if( bufferG != null ) {
		        bufferG.setFont( new java.awt.Font( "TimesRoman", java.awt.Font.BOLD, 18 ) );
        		bufferG.setColor( new java.awt.Color(-5203068) );
        		bufferG.fillRect( 0, 0, mSize.width, mSize.height );
        		bufferG.setColor( java.awt.Color.red );
	            this.drawClockNumbers( bufferG );
	            secondsThread = new SecondsThread( this, buffer, bufferG );
	            secondsThread.setPriority( Thread.MAX_PRIORITY );
	            if( hour != -1  &&  min != -1 )
	                secondsThread.setTime( hour, min, timeIsPM );
	            if( alarmHour != -1  &&  alarmMinute != -1 )
	                secondsThread.setAlarm( hour, min, alarmIsPM );
	            if( alarmDays != null )
	                secondsThread.setAlarmDays( alarmDays );
	            if( alarmClock != null )
	                secondsThread.setAlarmClockFrame( alarmClock );
	            secondsThread.start();
	        }
	    }
	}


    private void createBuffer( int width, int height ) {
        try {
    		buffer = this.createImage( width, height );
    		bufferG = buffer.getGraphics();
        } catch ( NullPointerException ex ) {
            buffer = null;
            bufferG = null;
        }
    }


	public void update( java.awt.Graphics g ) {
	    paint( g );
	}

	public void paint( java.awt.Graphics g ) {
	    g.drawImage( buffer, 0, 0, this );
	}


    public void setAlarmDays( java.util.Vector alarmDays ) {
        if( secondsThread != null )
            secondsThread.setAlarmDays( alarmDays );
        else
            this.alarmDays = alarmDays;
    }

    public void setTime( int hour, int min, boolean timeIsPM ) {
        if( secondsThread != null )
            secondsThread.setTime( hour, min, timeIsPM );
        else {
            this.hour = hour;
            this.min = min;
            this.timeIsPM = timeIsPM;
        }
    }


    public void setAlarm( int hour, int min, boolean alarmIsPM ) {
        if( secondsThread != null )
            secondsThread.setAlarm( hour, min, alarmIsPM );
        else {
            alarmHour = hour;
            alarmMinute = min;
            this.alarmIsPM = alarmIsPM;
        }
    }


    public void setAlarmClockFrame( AlarmClockFrame alarmClock ) {
        if( secondsThread != null )
            secondsThread.setAlarmClockFrame( alarmClock );
        else
            this.alarmClock = alarmClock;
    }



	private void drawClockNumbers( java.awt.Graphics g ) {
		g.drawOval( 1, 1, mSize.width-4, mSize.height-4 );
		g.drawOval( 2, 2, mSize.width-6, mSize.height-6 );
		java.awt.FontMetrics fm = g.getFontMetrics();
		int stringWidth = 0;

        int portion = (int)(((float)mSize.width - (float)mSize.width/2f)/3f);

		bufferG.drawString( "1", mSize.width/2 + (portion+10), portion-4 );

		bufferG.drawString( "2", mSize.width/2 + (2*portion+8), 2*(portion-2) );

		stringWidth = dph.util.Util.pixelsWideForString( "3", fm );
		bufferG.drawString( "3", mSize.width-(stringWidth + 10), mSize.height/2+6 );

		bufferG.drawString( "4", mSize.width/2 + (2*portion+8), mSize.height - (2*portion)+14 );

		bufferG.drawString( "5", mSize.width/2 + (portion+12), mSize.height - (portion-15) );

		stringWidth = dph.util.Util.pixelsWideForString( "6", fm );
		bufferG.drawString( "6", mSize.width/2-stringWidth/2, mSize.height-10 );

		bufferG.drawString( "7", mSize.width/2 - (portion+18), mSize.height - (portion-15) );

		bufferG.drawString( "8", mSize.width/2 - (2*portion+16), mSize.height - (2*portion)+18 );

		bufferG.drawString( "9", 10, mSize.height/2+6 );

		bufferG.drawString( "10", mSize.width/2 - (2*portion+20), 2*(portion-2) );

		bufferG.drawString( "11", mSize.width/2 - (portion+18), portion-4 );

		stringWidth = dph.util.Util.pixelsWideForString( "12", fm );
		bufferG.drawString( "12", mSize.width/2-stringWidth/2, 2+fm.getHeight() );
	}


	// Unit test
	static public void main( String[] args ) {
		java.awt.Frame frame = new java.awt.Frame( "Test ClockCanvas" );
		ClockCanvas clock = new ClockCanvas();
		clock.setSize( 300, 300 );
		java.awt.Panel p = new java.awt.Panel();
		p.add( clock );
		frame.add( "Center", p );
		frame.pack();
		frame.setVisible( true );
		frame.addWindowListener( new java.awt.event.WindowAdapter() {
			public void windowClosing( java.awt.event.WindowEvent evt ) {
				System.exit( 0 );
			}
		});
	}
}
