
package dph.play.alarmclock;

public final class SecondsThread extends Thread {
	private java.awt.Graphics bufferG;
	private java.awt.Component canvas;
	private java.awt.Image image;
	private int seconds, second, minute, hour;
	private final java.awt.Color secondColor = java.awt.Color.red;
	private final java.awt.Color minuteColor = java.awt.Color.blue;
	private final java.awt.Color hourColor = java.awt.Color.black;
	private AlarmClockFrame alarmClock;
	private boolean timeHasBeenSet = false;
	private boolean alarmHasBeenSet = false;
	private boolean timeIsPM, alarmIsPM;
	private int alarmHour, alarmMinute;
    private java.util.Vector alarmDays;
    private int[] xa = new int[3], ya = new int[3], oldSXa = new int[3], oldSYa = new int[3];
    private int[] oldMXa = new int[3], oldMYa = new int[3];
    private int[] oldHXa = new int[3], oldHYa = new int[3];



	public SecondsThread( java.awt.Component canvas, java.awt.Image image, java.awt.Graphics bufferG ) {
		this.canvas = canvas;
		this.bufferG = bufferG;
		this.image = image;
	}


    
    public void setAlarmClockFrame( AlarmClockFrame alarmClock ) {
        this.alarmClock = alarmClock;
    }
    
    
    
    public void setAlarmDays( java.util.Vector alarmDays ) {
        this.alarmDays = alarmDays;
    }
    
    

    public void setTime( int hour, int minute, boolean timeIsPM ) {
        if( hour == 12 )
            hour = 0;
        this.hour = hour;
        this.minute = minute;
        second = 0;
        this.timeIsPM = timeIsPM;
        timeHasBeenSet = true;;
    }



    public void setAlarm( int hour, int minute, boolean alarmIsPM ) {
        if( hour == 12 )
            hour = 0;
        alarmHour = hour;
        alarmMinute = minute;
        this.alarmIsPM = alarmIsPM;
        alarmHasBeenSet = true;
    }



    protected void tryAlarm() {
        //String am = alarmIsPM ? ("PM") : ("AM");
        //System.out.println( "Trying alarm which is set for " + alarmHour + ":" + alarmMinute + " " + am );
        java.util.Calendar date = java.util.Calendar.getInstance();
        Integer day = new Integer( date.get( java.util.Calendar.DAY_OF_WEEK ) );
        if( alarmHasBeenSet  &&  alarmDays.contains( day ) ) {
            if( alarmIsPM == timeIsPM ) {
                if( alarmHour == hour  &&  alarmMinute == minute ) {
                    //System.out.println( "Ringing alarm" );
                    alarmClock.ringAlarm();
                    alarmHasBeenSet = false;
                }
            }
        }
    }

    public void run() {
        while( true ) {
            tick();
            canvas.repaint();
            try {
                Thread.sleep( 999 );
            } catch( InterruptedException ex ) {
                // ignore it
            }
        }
    }
    
    
    private void drawHands() {
        double hourAngle = 2 * Math.PI * (seconds - 3 * 60 * 60) / (12 * 60 * 60);
        double minuteAngle  = 2 * Math.PI * (seconds - 15 * 60) / (60 * 60);
        double secondAngle = 2 * Math.PI * (seconds - 15) / 60;
        
        
        
        // Clear old second and draw new one
        bufferG.setColor( canvas.getBackground() );
        bufferG.fillPolygon( oldSXa, oldSYa, 3 );
        
        // Seconds color and draw center of watch
	    bufferG.setColor( secondColor );
        bufferG.fillOval( 120, 120, 12, 12 );
        
        int x = 125 + (int)(100 * Math.cos(secondAngle));
        int y = 125 + (int)(100 * Math.sin(secondAngle));
        if( (second >= 53) || (second < 8)  ||  (second >= 23  &&  second < 38) ) {
            oldSXa[0] = xa[0] = 128;
            oldSYa[0] = ya[0] = 125;
            oldSXa[2] = xa[2] = 122;
            oldSYa[2] = ya[2] = 125;
        }
        else {
            oldSXa[0] = xa[0] = 125;
            oldSYa[0] = ya[0] = 128;
            oldSXa[2] = xa[2] = 125;
            oldSYa[2] = ya[2] = 122;
        }
        oldSXa[1] = xa[1] = x;
        oldSYa[1] = ya[1] = y;
        bufferG.fillPolygon( xa, ya, 3 );
        
        // Clear old minute and draw new one
        bufferG.setColor( canvas.getBackground() );
        bufferG.fillPolygon( oldMXa, oldMYa, 3 );
        
        x = 125 + (int)(90 * Math.cos(minuteAngle));
        y = 125 + (int)(90 * Math.sin(minuteAngle));
	    bufferG.setColor( minuteColor );
        if( (minute >= 53) || (minute < 8)  ||  (minute >= 23  &&  minute < 38) ) {
            oldMXa[0] = xa[0] = 128;
            oldMYa[0] = ya[0] = 125;
            oldMXa[2] = xa[2] = 122;
            oldMYa[2] = ya[2] = 125;
        }
        else {
            oldMXa[0] = xa[0] = 125;
            oldMYa[0] = ya[0] = 128;
            oldMXa[2] = xa[2] = 125;
            oldMYa[2] = ya[2] = 122;
        }
        oldMXa[1] = xa[1] = x;
        oldMYa[1] = ya[1] = y;
        bufferG.fillPolygon( xa, ya, 3 );
		        
        // Clear old hour and draw new one        
        bufferG.setColor( canvas.getBackground() );
        bufferG.fillPolygon( oldHXa, oldHYa, 3 );
	    bufferG.setColor( hourColor );
	    x = 125 + (int)(70 * Math.cos(hourAngle));
	    y = 125 + (int)(70 * Math.sin(hourAngle));
        if( (hour > 10) || (hour < 2)  ||  (hour > 4  &&  hour <= 37) ) {
            oldHXa[0] = xa[0] = 128;
            oldHYa[0] = ya[0] = 125;
            oldHXa[2] = xa[2] = 122;
            oldHYa[2] = ya[2] = 125;
        }
        else {
            oldHXa[0] = xa[0] = 125;
            oldHYa[0] = ya[0] = 128;
            oldHXa[2] = xa[2] = 125;
            oldHYa[2] = ya[2] = 122;
        }
        oldHXa[1] = xa[1] = x;
        oldHYa[1] = ya[1] = y;
        bufferG.fillPolygon( xa, ya, 3 );
    }


    private void tick() {
        ++second;
        if( second >= 60 ) {
            second = 0;
            minuteTick();
        }    
        seconds = hour * 60 * 60 
            + minute * 60 
            + second;
        this.drawHands();
	    if( timeHasBeenSet  &&  alarmClock != null ) {
	        timeHasBeenSet = false;
	    }
    }
    
    
    private void minuteTick() {
        ++minute;
        if( minute >= 60 ) {
            minute = 0;
            this.hourTick();
        }
        if( alarmClock != null ) {
            alarmClock.setMinuteInTimeSpinner( minute );
	        tryAlarm();
        }
    }
    
    
    
    private void hourTick() {
        hour++;
        if( hour > 12 ) {
            hour = 0;
            timeIsPM = !timeIsPM;
        }
        if( alarmClock != null ) {
            alarmClock.setHourInTimeSpinner( hour );
        }    
    }
}
