
package dph.util;


public final class Util {

	public final static void debug( String msg ) {
		System.out.println( msg );
	}
	
	public static final void out( String msg ) {
	    debug( msg );
	}

    public final static void pause( String msg ) {
        out( msg );
        out( "cntrl<z> to continue" );
        try {
            while( System.in.read() != -1 ){}
        } catch( java.io.IOException ex ) {
        }
    }

    public final static void pause( String msg, int millis ) {
        out( msg );
        try {
            Thread.sleep( millis );
        } catch( InterruptedException ex ) {
        }
    }

	public static final void assert( boolean condition, String msg ) {
		if( !condition )
			debug( "assert Failed: " + msg );
	}


	public static final int pixelsWideForString( String str, java.awt.FontMetrics fm ) {
		return fm.stringWidth( str );
	}

	public static final int pixelsHighForString( String str, java.awt.FontMetrics fm ) {
		int height = fm.getHeight() + fm.getAscent() + fm.getDescent();
		return height * str.length();
	}
}
