package AWTExtensions;

import java.lang.reflect.*;
import java.util.EventObject;

public class AWTBaseDelegate 
{
    protected Object m_obj;
    protected Method m_method;
    
    public AWTBaseDelegate( Object handlerObject, String methodName )
    {
        m_obj = handlerObject;
        Class clazz = m_obj.getClass();
        m_method = bind( clazz, methodName, new Class[] { java.util.EventObject.class } );
    }
    
    protected AWTBaseDelegate()
    {
    }
    
    protected Method bind( Class clazz, String methodName, Class[] parameters )
    {        
        try
        {
            return clazz.getDeclaredMethod( methodName, parameters);
        } catch ( Exception e )
        {
            throw new AWTDelegateException( e.getMessage() );
        }
    }
    
    public void fireEvent ( EventObject event )
    {
        fireEvent( m_obj, m_method, event );
    }
    
    protected void fireEvent ( Object obj, Method method, EventObject event )
    {
        if ( ( method != null ) && ( obj != null ) )
        {
            try
            {
                method.invoke( obj, new Object[] { event } );
            } catch ( Exception e )
            {
                throw new AWTDelegateException( );
            }
        }
    }
}
