package AWTExtensions;

import java.awt.*;

public class AWTProgressBar extends Frame
{
    protected int m_max = 0;
    protected int m_step = 0;
    
    public AWTProgressBar ( int max, String title )
    {
        super( title );
        m_max = max;
        initForm();
    }
    
    public void initForm()
    {
        setSize( 200,60 );
        this.setBackground( Color.lightGray );
        this.show();
    }
    
    public synchronized void setStep ( int step )
    {
        m_step = step;
        showBar( );
    }
    
    public void showBar (  )
    {
        Graphics g = this.getGraphics();
        Dimension dim = this.getSize();
        Insets insets = this.getInsets();
        int top = insets.top + 5;
        int bottom = insets.bottom + 5;
        
        float xScale = (float)(dim.width - (insets.right + insets.left)) / (float)m_max;
        int barHeight = dim.height - bottom;
        int width =(int)( xScale * m_step );
        
        g.setColor( Color.blue );
        g.fillRect( insets.left, top, width , barHeight );
    }
}
