package AWTExtensions;

import java.awt.event.*;
import java.lang.reflect.*;

public class WindowDelegate extends AWTBaseDelegate implements WindowListener
{
    protected boolean m_singleHandler = false;
    public WindowDelegate( Object handlerObject, String methodName )
    {
        m_obj = handlerObject;
        Class clazz = m_obj.getClass();
        m_method = bind( clazz, methodName, new Class[] { java.util.EventObject.class } );
        m_singleHandler = true;
    }
    
    public WindowDelegate( Object handlerObject )
    {
        m_obj = handlerObject;
        
    }
    
    public WindowDelegate( Object handlerObject, String methodName, int type )
    {
        m_obj = handlerObject;
        addWindowHandler( methodName, type );
    }
    
    protected void fireEvent ( WindowEvent e, Method windowMethod )
    {    
        if ( m_singleHandler )
        {
            fireEvent ( e );
        } else
        {
            if (( m_obj != null ) && ( windowMethod != null ) )
            {
                fireEvent( m_obj, windowMethod, e );
            }
        }
    }
    
    protected Method m_windowOpened = null;
    protected Method m_windowClosing = null;
    protected Method m_windowClosed = null;
    protected Method m_windowIconified = null;
    protected Method m_windowDeiconified = null;
    protected Method m_windowActivated = null;
    protected Method m_windowDeactivated = null;
    
    public final static int OPENED      = 1;
    public final static int CLOSING     = 2;
    public final static int CLOSED      = 3;
    public final static int ICONIFIED   = 4;
    public final static int DEICONIFIED = 5;
    public final static int ACTIVATED   = 6;
    public final static int DEACTIVATED = 7;
    
    public void windowClosing( WindowEvent e )
    {
        fireEvent( e, m_windowClosing );
    }
    
    public void addWindowHandler ( String methodName, int type )
    {
        Method handler = bind(m_obj.getClass(), methodName, new Class[] { java.awt.event.WindowEvent.class } );
        switch ( type )
        {
        case OPENED:
            m_windowOpened = handler;
            break;
        case CLOSING:
            m_windowClosing = handler;
            break;
        case CLOSED:
            m_windowClosed = handler;
            break;
        case ICONIFIED:
            m_windowIconified = handler;
            break;
        case DEICONIFIED:
            m_windowDeiconified = handler;
            break;
        case ACTIVATED:
            m_windowActivated = handler;
            break;
        case DEACTIVATED:
            m_windowDeactivated = handler;
            break;
        }
    }
        
    public void windowClosed( WindowEvent e )
    {
        fireEvent( e, m_windowClosed );
    }
    
    public void windowIconified( WindowEvent e )
    {
        fireEvent( e, m_windowIconified );
    }
    
    public void windowDeiconified( WindowEvent e )
    {
        fireEvent( e, m_windowDeiconified );
    }
    
    public void windowOpened( WindowEvent e )
    {
        fireEvent( e, m_windowOpened );
    }
    
    public void windowActivated( WindowEvent e )
    {
        fireEvent( e, m_windowActivated );
    }
    
    public void windowDeactivated( WindowEvent e )
    {
        fireEvent( e, m_windowDeactivated );
    }
}
