import java.util.*;

public abstract class App
{
    protected int[] m_items;
    public App(int items)
    {
        m_items = new int[ items ];
        fillItems( m_items );
    }
    
    protected void fillItems( int[] items )
    {
        Random rnd = new Random();
        for ( int i = 0; i < items.length; i++ )
        {
            int tmp;
            do 
            {
                tmp = rnd.nextInt(); 
            } while ( tmp < 0 );
            m_items[i] = tmp; 
        }
    }
    
    public int[] sortItems( int[] items )
    {
        int[] sortedList = new int[ items.length ];
        System.arraycopy( m_items, 0, sortedList, 0, m_items.length );
        for ( int i = 0; i < sortedList.length; i++ )
        {
            for( int j = i; j < sortedList.length; j++ )
            {
                if (  sortedList[i] > sortedList[j] )
                {
                    int tmp = sortedList[j];
                    sortedList[j] = sortedList[i];
                    sortedList[i] = tmp;
                }
            }
           sortProgressEvent( i, m_items.length );
        }
        sortCompleteEvent();
        return sortedList;
    }
    
    public int[] getItems( )
    {
        return m_items;
    }
    
    protected abstract void sortCompleteEvent( );
    protected abstract void sortProgressEvent( int position, int total );
}
