// Example1.java
import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.wfc.html.*;
import WFCExtensions.*;

public class Example1 extends Form
{
    
    WFCApp m_app;
    ProgressDialog m_pDlg;
    int[] m_items;
    int[] m_sortedItems;
       
    
	public Example1()
	{
		super();
        m_app = new WFCApp ( 2500 );
        m_items = m_app.getItems();
        m_sortedItems = m_app.sortItems( m_items );
        
        // bind custom delegate classes to WFCApp class
        m_app.addOnSortCompletionEvent( new WFCSortEventDelegate( this.sortCompletionEvent ) );
        m_app.addOnSortProgressEvent( new WFCSortEventDelegate( this.sortProgressEvent ) );
		initForm();	
	}
	
	public void dispose()
	{
		super.dispose();
		components.dispose();
	}
    
    // 
    private void showItems( )
    {
        Graphics g = graphPanel.createGraphics();
        Rectangle dispRect = graphPanel.getDisplayRect();
        g.clearRect( dispRect );
        int y = dispRect.height;       
        
        int biggest = m_sortedItems[ m_sortedItems.length - 1 ];
        float yScale = (float)biggest / (float)y ;
        float xScale =  (float)m_items.length / (float)graphPanel.getSize().x;
        
        int lastY = 0;
        for ( int i = 0; i < m_items.length; i++ )
        {
            if ( i == 0 )
            {
                lastY = ( y - (int)(m_items[i] / yScale) );
                g.drawLine( new Point( (int)(i / xScale), lastY ),
                        new Point( (int)(i / xScale), lastY) );
            } else
            {
                int newY = ( y - (int)(m_items[i] / yScale) );
                g.drawLine ( new Point( (int)((i - 1) / xScale), lastY ),
                             new Point( (int)(i / xScale), newY ) );
                lastY = newY;
            }
        }
    }
    // sort event handlers
    
    private void sortProgressEvent( Object src, WFCSortEvent e )
    {
        m_pDlg.progressBar.setValue( e.getPosition() );        
    }
    
    private void sortCompletionEvent( Object src, WFCSortEvent e )
    {
        m_pDlg.close();
        m_pDlg = null;
    }
    
    // UI event handlers
    
    private void sortClick(Object source, Event e)
    {
        m_pDlg = new ProgressDialog();
        m_pDlg.show();
        m_pDlg.progressBar.setMaximum( m_items.length );
        
        m_items = m_app.sortItems( m_items );
        
        showItems();
    }
    
    private void panelPaint(Object source, PaintEvent e)
    {
        showItems();
    }
    
    private void panelResize(Object source, Event e)
    {
        showItems();
    }

    /**
     * NOTE: The following code is required by the Visual J++ form
     * designer.  It can be modified using the form editor.  Do not
     * modify it using the code editor.
     */
    Container components = new Container();
    Button sortButton = new Button();
    Panel graphPanel = new Panel();

    private void initForm()
    {
        this.setText("WFC Example");
        this.setAutoScaleBaseSize(new Point(5, 13));
        this.setClientSize(new Point(300, 300));
        this.addOnResize(new EventHandler(this.panelResize));
        this.addOnPaint(new PaintEventHandler(this.panelPaint));

        sortButton.setDock(ControlDock.BOTTOM);
        sortButton.setLocation(new Point(0, 277));
        sortButton.setSize(new Point(300, 23));
        sortButton.setTabIndex(0);
        sortButton.setText("Sort");
        sortButton.addOnClick(new EventHandler(this.sortClick));

        graphPanel.setBackColor(Color.WINDOW);
        graphPanel.setDock(ControlDock.FILL);
        graphPanel.setSize(new Point(300, 277));
        graphPanel.setTabIndex(1);
        graphPanel.setText("panel1");
        graphPanel.setBorderStyle(BorderStyle.FIXED_3D);

        this.setNewControls(new Control[] {
                            graphPanel, 
                            sortButton});
    }

	// main entry point
	public static void main(String args[])
	{
		Application.run(new Example1());
	}
}
