import java.awt.*;
import java.awt.event.*;
import AWTExtensions.*;
import java.applet.*;

public class Example2 extends Frame
{
    AWTApp m_app;
    AWTProgressBar m_progBar;
    int[] m_items;
    int[] m_sortedItems;
    
    Button sortButton = new Button();
    Panel graphPanel = new Panel() 
        { 
            public void paint ( Graphics g )
            {
                showItems( g, this.getLocation(), this.getSize() );
            } 
        };
    
	public static void main(String[] args)
	{
        Example2 ex = new Example2();
	}
    
    public Example2 ( )
    {
        super();
        
        m_app = new AWTApp ( 2500 );
        m_items = m_app.getItems();
        m_sortedItems = m_app.sortItems( m_items );
        
        initForm();	
    }
    
    public void sortCompletionEvent( AWTSortEvent e )
    {
        m_progBar.setVisible( false );
        m_progBar.dispose();
        m_progBar = null;
    }
    
    public synchronized void sortProgressEvent( AWTSortEvent e )
    {
        m_progBar.setStep( e.getPosition() );
    }
    
    protected void showItems( Graphics g, Point location, Dimension size )
    {
        g.clearRect( location.x, location.y, size.width, size.height );
        
        int y = size.height;       
        
        int biggest = m_sortedItems[ m_sortedItems.length - 1 ];
        float yScale = (float)biggest / (float)y ;
        float xScale =  (float)m_items.length / (float)size.width;
        
        int lastY = 0;
        for ( int i = 0; i < m_items.length; i++ )
        {
            if ( i == 0 )
            {
                lastY = ( y - (int)(m_items[i] / yScale) );
                g.drawLine( (int)(i / xScale), lastY ,
                            (int)(i / xScale), lastY);
            } else
            {
                int newY = ( y - (int)(m_items[i] / yScale) );
                g.drawLine ( (int)((i - 1) / xScale), lastY,
                             (int)(i / xScale), newY );
                lastY = newY;
            }
        }
    }
    
    public void initForm ( )
    {
        this.setSize( 320, 200 );
        this.setTitle( "AWT Example" );
        this.setLayout( new BorderLayout() );
        this.add( "Center", graphPanel );
        this.add( "South", sortButton );
        this.setLocation(200,200 );
        
        sortButton.setLabel( "Sort" );
        
        /**
         * Anonymous class event handlers
         */
        sortButton.addMouseListener( new MouseAdapter() 
            {
                public void mouseClicked( MouseEvent e )
                {
                    m_progBar = new AWTProgressBar( m_items.length, "Sort Progress" );
                    m_progBar.setLocation( getLocation() );
                    m_progBar.show();
                    m_items = m_app.sortItems( m_items );
                    graphPanel.repaint();
                }
            } );
                
       
        
        /**
         * Delegate class event handlers
         */
        m_app.addOnSortCompletionEvent( new SortDelegate( this, "sortCompletionEvent" ) );
        m_app.addOnSortProgressEvent( new SortDelegate( this, "sortProgressEvent" ) );
        
        this.addWindowListener( new WindowDelegate( this, "windowClosing", WindowDelegate.CLOSING ) ); 
        
        this.show();
    }
    
    public void windowClosing ( WindowEvent e )
    {
        System.exit(1);
    }
}
