package WFCExtensions;

import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.lang.Delegate;
public class WFCApp extends App
{
    WFCSortEventDelegate m_SortCompletionEvent;
    WFCSortEventDelegate m_SortProgressEvent;
    public WFCApp ( int items )
    {
        super ( items );
    }
    
    public void addOnSortCompletionEvent(WFCSortEventDelegate value)
    {
        m_SortCompletionEvent = (WFCSortEventDelegate)Delegate.combine(m_SortCompletionEvent, value);
    }

    public void addOnSortProgressEvent(WFCSortEventDelegate value)
    {
        m_SortProgressEvent = (WFCSortEventDelegate)Delegate.combine(m_SortProgressEvent, value);
    }

    protected void onSortCompletionEvent(WFCSortEvent event)
    {
        if (m_SortCompletionEvent != null) m_SortCompletionEvent.invoke(this, event);
    }

    protected void onSortProgressEvent(WFCSortEvent event)
    {
        if (m_SortProgressEvent != null) m_SortProgressEvent.invoke(this, event);
    }

    public void removeOnSortCompletionEvent(WFCSortEventDelegate value)
    {
        m_SortCompletionEvent = (WFCSortEventDelegate)Delegate.remove(m_SortCompletionEvent, value);
    }

    public void removeOnSortProgressEvent(WFCSortEventDelegate value)
    {
        m_SortProgressEvent = (WFCSortEventDelegate)Delegate.remove(m_SortProgressEvent, value);
    }

    protected void sortCompleteEvent( )
    {
        WFCSortEvent e = new WFCSortEvent();
        onSortCompletionEvent( e );
    }
    
    protected void sortProgressEvent( int position, int total )
    {
        WFCSortEvent e = new WFCSortEvent ( position, total );
        onSortProgressEvent( e );
    }
    
    
    public static class ClassInfo extends com.ms.wfc.core.ClassInfo
    {
        public static final EventInfo sortCompletionEvent = new EventInfo(
			WFCApp.class, "sortCompletionEvent", EventHandler.class);
        public static final EventInfo sortProgressEvent = new EventInfo(
			WFCApp.class, "sortProgressEvent", EventHandler.class);
        public void getEvents(IEvents events)
        {
            super.getEvents(events);
            events.add(sortProgressEvent);
            events.add(sortCompletionEvent);
        }

        public void getProperties(IProperties props)
        {
            super.getProperties(props);
        }
    }
}
