package com.beechwood.crypto.cipher;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;

import com.beechwood.crypto.spec.EnigmaParameterSpec;

public class Enigma extends CipherSpi{

  private int opmode;

  private EnigmaMachine machine;

  protected byte[] engineDoFinal(byte[] input,
     int inputOffset, int inputLen)
       throws IllegalBlockSizeException, BadPaddingException { 
    byte[] output = new byte[inputLen];
    machine.processMessage(input, inputOffset, output, 0, inputLen);
    return output;
  }

  protected int engineDoFinal(byte[] input, 
      int inputOffset, int inputLen,
      byte[] output, int outputOffset)
        throws ShortBufferException, IllegalBlockSizeException,
           BadPaddingException { 
    if ((outputOffset + inputLen) > output.length) 
      throw new ShortBufferException();
    machine.processMessage(input, inputLen, output, 
      outputOffset, inputLen);
    return inputLen;
  }

  protected int engineGetBlockSize() {
    return 0;
  }

  protected byte[] engineGetIV()  {
    return null;
  }

  protected int engineGetOutputSize(int inputLen) {
    return inputLen;
  }

  protected void engineInit(int opmode, Key key, SecureRandom random) 
      throws InvalidKeyException {
  int[] notches;
  int[] startPositions;
  byte[] enc = key.getEncoded();
  SecureRandom rand = random;
  rand.setSeed(enc);
  this.opmode = opmode;
  notches = new int[3];
  startPositions = new int[3];

  byte[] encForm = key.getEncoded();
  int kx = encForm.length;
  int rotorCount = notches.length;
  for (int i = 0; i < rotorCount; ++i) {
    --kx;
    if (kx < 0)
      kx = encForm.length - 1;
    notches[i] = encForm[kx] & 0xff; 
    --kx;
    if (kx < 0)
      kx = encForm.length - 1;
    startPositions[i] = encForm[kx] & 0xff;
  }
  constructEnigmaMachine(notches, startPositions, random);
  }

 protected void engineInit(int opmode, Key key,
     AlgorithmParameterSpec params, SecureRandom random)
       throws InvalidKeyException,
         InvalidAlgorithmParameterException  {
  int[] notches;
  int[] startPositions;
  byte[] enc = key.getEncoded();
  SecureRandom rand = random;
  rand.setSeed(enc);
    if ((opmode != Cipher.ENCRYPT_MODE) &&
        (opmode != Cipher.DECRYPT_MODE))
      throw new InvalidAlgorithmParameterException
        ("invalid ENCRYPT/DECRYPT mode");
    this.opmode = opmode;
    notches = ((EnigmaParameterSpec)params).getNotchPositions();
    startPositions = ((EnigmaParameterSpec)params).getStartPositions();
    byte[] encForm = key.getEncoded();
    constructEnigmaMachine(notches, startPositions, random);
  }

  protected void engineSetMode(String mode)
   throws NoSuchAlgorithmException {
  }

  protected void engineSetPadding(String padding)
   throws NoSuchPaddingException {
    throw new NoSuchPaddingException();
  }

  protected byte[] engineUpdate(byte[] input,
    int inputOffset, int inputLen) {
    byte[] output = new byte[inputLen];
    machine.processMessage(input, inputOffset, output, 0, inputLen);
    return output;
  }

  protected int engineUpdate(byte[] input,
    int inputOffset, int inputLen,
     byte[] output, int outputOffset)
       throws ShortBufferException {
    if ((outputOffset + inputLen) > output.length) 
      throw new ShortBufferException();
    machine.processMessage(input, inputOffset, output, 
      outputOffset, inputLen);
    return inputLen;
  }

  private void constructEnigmaMachine(int[] notches, 
      int[] startPositions, SecureRandom random) {
    EnigmaRotor[] rotors;
    EnigmaReflector reflector;
    byte[] rb = new byte[1];
    int rotorCount = notches.length;
    rotors = new EnigmaRotor[rotorCount];
    for (int i = 0; i < rotorCount; ++i) {
      random.nextBytes(rb); 
      rotors[i] = new EnigmaRotor((long)rb[0],notches[i]);
      rotors[i].setStartingPosition(startPositions[i]);
    }
    random.nextBytes(rb); 
    reflector = new EnigmaReflector((long)rb[0]);
    machine = new EnigmaMachine(rotors, reflector);
  }
}
