package com.beechwood.crypto.spec;

import com.beechwood.crypto.interfaces.EnigmaParams;
import java.security.spec.AlgorithmParameterSpec;

public class EnigmaParameterSpec extends Object
    implements AlgorithmParameterSpec, EnigmaParams {

  int rotorCount;
  int[] notchPositions;
  int[] startPositions;

  public EnigmaParameterSpec(int[] notchPositions, 
    int[] startPositions) {

    rotorCount = Math.min(notchPositions.length, startPositions.length);
    this.notchPositions = new int[rotorCount];
    this.startPositions = new int[rotorCount];

    for (int i = 0; i < rotorCount; ++i) {
      this.notchPositions[i] = notchPositions[i];
      this.startPositions[i] = startPositions[i];
    }
  }

  public int[] getNotchPositions() {
    return notchPositions;
  }

  public int[] getStartPositions() {
    return startPositions;
  }

  public int getRotorCount() {
    return rotorCount;
  }
}
