import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

import com.beechwood.crypto.cipher.Base64;
import com.beechwood.crypto.cipher.Base64Exception;
import com.beechwood.crypto.spec.EnigmaParameterSpec;

class EnigmaTest {

  public static void main(String[] args) {

  Cipher cipher = null;

  try {
    cipher = Cipher.getInstance("Enigma");
    //cipher = Cipher.getInstance("Enigma", "Corbett");
    System.out.println("got instance of cipher - provider is " + 
      cipher.getProvider());
  }
/*
  catch (NoSuchProviderException nspe) {
    System.out.println("requested provider not found");
    System.exit(0);
  }
*/
  catch (NoSuchAlgorithmException nsae) {
    System.out.println("requested algorithm not found");
    System.exit(0);
  }
  catch (NoSuchPaddingException nspe) {
    System.out.println("no such padding");
    System.exit(0);
  }

  SecretKey skey = null;
  try {
    String passPhrase = "of shoes and strings and sealing wax";
    SecretKeyFactory skf = SecretKeyFactory.getInstance("PBE");
    PBEKeySpec kspec = new PBEKeySpec(passPhrase);
    skey = skf.generateSecret(kspec);
  }
  catch (NoSuchAlgorithmException nsae) {
    System.out.println("secret key algorithm not found");
  }
  catch (InvalidKeySpecException ikse) {
    System.out.println("invalid key specification");
  }

  EnigmaParameterSpec espec = null;
  try {
    int[] notches = {31, 54, 72, 91, 133, 101, 101, 200, 10, 22};
    int[] startpos = {11, 102, 13, 74, 225, 116, 7, 38, 99, 100};
    espec = new EnigmaParameterSpec(notches,startpos);
    cipher.init(Cipher.ENCRYPT_MODE, skey ,espec);
  }
  catch (InvalidAlgorithmParameterException iape) {
    System.out.println("invalid algorithm parameter");
  }
  catch (InvalidKeyException ike) {
    System.out.println("invalid key");
  }
  String testMessage = "This is a test (how imaginative!)";

  System.out.println("original message is: " + testMessage);
  String msg64 = Base64.encode(testMessage.getBytes());
  byte[] clearText = testMessage.getBytes();
  System.out.println("Original message (base64) is:");
  Base64.display(msg64);

  try {
    byte[] cipherText = cipher.doFinal(clearText);
    msg64 = Base64.encode(cipherText);
    System.out.println("Encrypted message (base64) is:");
    Base64.display(msg64);
    cipher.init(Cipher.DECRYPT_MODE, skey ,espec);
    clearText = cipher.doFinal(cipherText);
    msg64 = Base64.encode(clearText);
    System.out.println("Decrypted message (base64) is:");
    Base64.display(msg64);
    System.out.println("message after encryption/decryption is: " + 
      new String(clearText));
  }
  catch (IllegalBlockSizeException ibse) {
  }
  catch (BadPaddingException bpe) {
  }
  catch (InvalidAlgorithmParameterException iape) {
    System.out.println("invalid algorithm parm");
  }
  catch (InvalidKeyException ike) {
    System.out.println("invalid key");
  }
  System.exit(0);
  }
}
