// JukeBoxDlg.cpp
#include "stdafx.h"
#include "JukeBox.h"
#include "JukeBoxDlg.h"
#include "midiplayer.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
// CJukeBoxDlg dialog
CJukeBoxDlg::CJukeBoxDlg(CWnd* pParent)	: CDialog(CJukeBoxDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CJukeBoxDlg)
	m_Key = _T("");
	m_Time = _T("");
	m_Metronome = FALSE;
	m_Tempo = _T("");
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	isplaying = false;
	devid = 0;
	midiplay = 0;
}
CJukeBoxDlg::~CJukeBoxDlg()
{
	delete midiplay;
}
void CJukeBoxDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CJukeBoxDlg)
	DDX_Control(pDX, IDC_SECONDS, m_Seconds);
	DDX_Control(pDX, IDC_TEMPOSPIN, m_Tempospin);
	DDX_Control(pDX, IDC_UP, m_Up);
	DDX_Control(pDX, IDC_DOWN, m_Down);
	DDX_Control(pDX, IDC_COUNTOFF, m_Countoff);
	DDX_Control(pDX, IDC_PLAYLIST, m_Playlist);
	DDX_Control(pDX, IDC_PLAY, m_Play);
	DDX_Text(pDX, IDC_KEY, m_Key);
	DDX_Text(pDX, IDC_TIME, m_Time);
	DDX_Check(pDX, IDC_METRONOME, m_Metronome);
	DDX_Text(pDX, IDC_TEMPO, m_Tempo);
	DDV_MaxChars(pDX, m_Tempo, 3);
	//}}AFX_DATA_MAP
}
BEGIN_MESSAGE_MAP(CJukeBoxDlg, CDialog)
	//{{AFX_MSG_MAP(CJukeBoxDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_DESTROY()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_ADDFILE, OnAddfile)
	ON_LBN_SELCHANGE(IDC_PLAYLIST, OnSelchangePlaylist)
	ON_BN_CLICKED(IDC_PLAY, OnPlay)
	ON_BN_CLICKED(IDC_CLEAR, OnClear)
	ON_BN_CLICKED(IDC_REMOVEFILE, OnRemovefile)
	ON_LBN_DBLCLK(IDC_PLAYLIST, OnDblclkPlaylist)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_METRONOME, OnMetronome)
	ON_BN_CLICKED(IDC_DOWN, OnDown)
	ON_BN_CLICKED(IDC_UP, OnUp)
	ON_WM_PAINT()
	ON_EN_CHANGE(IDC_TEMPO, OnChangeTempo)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

const static int mintempo = 50;
const static int maxtempo = 280;

BOOL CJukeBoxDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	// --- set the icons for the dialog buttons
	m_Play.SetIcon(theApp.m_hPlayIcon);
	m_Up.SetIcon(theApp.m_hUpIcon);
	m_Down.SetIcon(theApp.m_hDownIcon);
	// --- set the range and setting for the count-off number of measures
	m_Countoff.SetRange(0,4);
	m_Countoff.SetPos(theApp.GetProfileInt("Settings", "Countoff", 0));
	// --- set the range and setting for the delay in seconds between songs
	m_Seconds.SetRange(0,30);
	m_Seconds.SetPos(theApp.GetProfileInt("Settings", "Delay", 2));
	// --- set the metronome checkbox
	m_Metronome = theApp.GetProfileInt("Settings", "Metronome", 0);
	// --- set the range for the tempo spin button
	m_Tempospin.SetRange(mintempo,maxtempo);
	UpdateData(FALSE);
	// --- put the about selection on the system meny
	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())	{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	// --- load the previous file list and song tempos from the registry
	int size = theApp.GetProfileInt("Settings", "Files", 0);
	for (int ct = 0; ct < size; ct++)	{
		CString fc;
		fc.Format("File%03d", ct + 1);
		CString file = theApp.GetProfileString("Settings", fc);
		if (!file.IsEmpty())	{
			fc.Format("Tempo%03d", ct + 1);
			unsigned int tmpo = theApp.GetProfileInt("Settings", fc, 0);
			AddFile(file.GetBuffer(0), tmpo);
		}
	}
	// ----- select the file that was last selected
	short int cursel = theApp.GetProfileInt("Settings", "File", -1);
	if (size > 0 && (cursel == -1 || cursel >= size))
		cursel = 0;
	m_Playlist.SetCurSel(cursel);
	OnSelchangePlaylist();	// displays the song's tempo, etc. in the dialog
	return TRUE;
}
void CJukeBoxDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	// ---- display the about dialog
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)	{
		CDialog dlgAbout(IDD_ABOUTBOX);
		dlgAbout.DoModal();
	}
	else
		CDialog::OnSysCommand(nID, lParam);
}
void CJukeBoxDlg::OnDestroy()
{
	int size = midfiles.size();
	// --- save the file list in the registry
	theApp.WriteProfileInt("Settings", "Files", size);
	std::vector<midfiledata>::iterator iter;
	int ct = 0;
	for (iter = midfiles.begin(); iter != midfiles.end(); ct++, iter++)	{
		CString fc;
		fc.Format("File%03d", ct + 1);
		theApp.WriteProfileString("Settings", fc, iter->filename.c_str());
		fc.Format("Tempo%03d", ct + 1);
		theApp.WriteProfileInt("Settings", fc, iter->tempo);
	}
	UpdateData();
	// --- save the count-off and metronome settings in the registry
	theApp.WriteProfileInt("Settings", "Delay", m_Seconds.GetPos());
	theApp.WriteProfileInt("Settings", "Countoff", m_Countoff.GetPos());
	theApp.WriteProfileInt("Settings", "Metronome", m_Metronome);
	// --- save the current selected file in the registry
	theApp.WriteProfileInt("Settings", "File", m_Playlist.GetCurSel());
	WinHelp(0L, HELP_QUIT);
	CDialog::OnDestroy();
}
HCURSOR CJukeBoxDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}
void CJukeBoxDlg::AddFile(const std::string& file, unsigned int tmpo)
{
	// ---- open the file to be added to the list
	std::ifstream ifile(file.c_str(),std::ios::binary);
	// --- ensure that the file still exists
	if (!ifile.fail())	{
		// --- read the file's midi information to display
		MIDIInfo mi(ifile);
		mi.ReadMIDIFile();
		// ---- get the file's song title (text 3 event)
		std::string title = mi.Title();
		if (title.empty())	{
			// --- the file has no text 3 event (or it's empty),
			//     use the file name in the play list
			int n = file.rfind('\\');
			if (n != -1)
				title = file.substr(n+1, file.length() - (n+1));
		}
		m_Playlist.AddString(title.c_str());	// display the title
		// -- gather the file's name, tempo, key signature, and time signature
		midfiledata filedata;
		filedata.filename = file;
		// --- use parameter tmpo if provided
		//     else use file's tempo if provided
		//     else use 100 bpm (6000000 us per 1/4 note)
		filedata.tempo = tmpo ? tmpo : mi.Tempo() ? mi.Tempo() : 600000;
		filedata.key = mi.Key();
		filedata.time = mi.Time();
		// --- save the file info in a table to display its data when selected
		midfiles.push_back(filedata);
	}
}
void CJukeBoxDlg::OnAddfile()
{
	// ---- go to the path last used to select files to display
	CString path = theApp.GetProfileString("Settings", "Path");
	if (!path.IsEmpty())
		_chdir(path.GetBuffer(0));
	// --- common open file dialog
	CFileDialog dlg(TRUE,
					"mid",
					0,
					OFN_ALLOWMULTISELECT | 
					OFN_HIDEREADONLY | 
					OFN_FILEMUSTEXIST | 
					OFN_PATHMUSTEXIST,
					"Standard Midi Format Files (*.mid)|*.mid||"
					);

	if (dlg.DoModal() == IDOK)	{
		// --- save the count to set current selection to beginning of what is added
		int nSel = m_Playlist.GetCount();
		// --- add the selected file(s) to the play list
		POSITION pos = dlg.GetStartPosition();
		int ct = 0;
		do	{
			path = dlg.GetNextPathName(pos);
			AddFile(path.GetBuffer(0));
			ct++;
		} while (pos != 0);
		// --- post the path to the registry for next time
		path = dlg.GetPathName();
		if (ct == 1)	{
			int ndx = path.ReverseFind('\\');
			if (ndx != -1)
				path = path.Left(ndx+1);
		}
		theApp.WriteProfileString("Settings", "Path", path);
		// --- set the selection to the first of the files added
		m_Playlist.SetCurSel(nSel);
		OnSelchangePlaylist();	// displays the song's tempo, etc. in the dialog
	}
}
void CJukeBoxDlg::OnPlay() 
{
	if (!isplaying)
		StartSong();
	else	{
		midiplay->Reset();
		StopSong();
	}
}
void CJukeBoxDlg::StartSong()
{
	int nSel = m_Playlist.GetCurSel();
	if (nSel != LB_ERR)	{
		m_Play.SetIcon(theApp.m_hStopIcon);
		isplaying = true;
		std::ifstream ifile(midfiles[nSel].filename.c_str(),std::ios::binary);
		delete midiplay;
		midiplay = new MIDIPlayer(ifile);
		midiplay->RegisterWindow(this);
		midiplay->ReadMIDIFile();
		UpdateData();
		midiplay->Play(midfiles[nSel].tempo, m_Countoff.GetPos(), m_Metronome);
	}
}
void CJukeBoxDlg::StopSong()
{
	m_Play.SetIcon(theApp.m_hPlayIcon);
	isplaying = false;
	midiplay->StopPlay();
}
LRESULT CJukeBoxDlg::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	if (message == MM_MCINOTIFY && isplaying)	{
		StopSong();
		int sec = m_Seconds.GetPos();
		if (sec)
			SetTimer(0, sec * 1000, 0);
		else
			PlayNextSong();
	}
	return CDialog::WindowProc(message, wParam, lParam);
}
void CJukeBoxDlg::OnClear() 
{
	midfiles.clear();
	m_Playlist.ResetContent();
}
void CJukeBoxDlg::OnRemovefile() 
{
	int nSel = m_Playlist.GetCurSel();
	if (nSel != LB_ERR)	{
		midfiles.erase(midfiles.begin() + nSel);
		m_Playlist.DeleteString(nSel);
		int ct = m_Playlist.GetCount();
		if (ct > 0)	{
			if (nSel == ct)
				--nSel;
			m_Playlist.SetCurSel(nSel);
			OnSelchangePlaylist();	// displays the song's tempo, etc. in the dialog
		}
	}	
}
void CJukeBoxDlg::OnDblclkPlaylist() 
{
	OnPlay();	
}
void CJukeBoxDlg::PlayNextSong()
{
	int nSel = m_Playlist.GetCurSel();
	if (nSel != LB_ERR && nSel < m_Playlist.GetCount() - 1)	{
		m_Playlist.SetCurSel(++nSel);
		OnSelchangePlaylist();	// displays the song's tempo, etc. in the dialog
		StartSong();
	}
}
void CJukeBoxDlg::OnTimer(UINT nIDEvent) 
{
	KillTimer(0);
	PlayNextSong();
	CDialog::OnTimer(nIDEvent);
}
void CJukeBoxDlg::OnMetronome() 
{
	if (midiplay)	{
		UpdateData();
		midiplay->Metronome(m_Metronome);
	}
}
void CJukeBoxDlg::OnDown() 
{
	int nSel = m_Playlist.GetCurSel();
	if (nSel != -1 && nSel < m_Playlist.GetCount() - 1)	{
		midfiledata filedata = midfiles[nSel];
		std::vector<midfiledata>::iterator iter = &midfiles[nSel];
		midfiles.erase(iter);
		midfiles.insert(iter+1, filedata);

		CString strSongName;
		m_Playlist.GetText(nSel, strSongName);
		m_Playlist.DeleteString(nSel++);		
		m_Playlist.InsertString(nSel, strSongName);
		m_Playlist.SetCurSel(nSel);
	}
}
void CJukeBoxDlg::OnUp() 
{
	int nSel = m_Playlist.GetCurSel();
	if (nSel > 0)	{
		midfiledata filedata = midfiles[nSel];
		std::vector<midfiledata>::iterator iter = &midfiles[nSel];
		midfiles.erase(iter);
		midfiles.insert(iter-1, filedata);

		CString strSongName;
		m_Playlist.GetText(nSel, strSongName);
		m_Playlist.DeleteString(nSel);		
		m_Playlist.InsertString(--nSel, strSongName);
		m_Playlist.SetCurSel(nSel);
	}
}
void CJukeBoxDlg::OnSelchangePlaylist() 
{
	m_Tempo.Empty();
	int nSel = m_Playlist.GetCurSel();
	if (nSel != LB_ERR)	{
		int tempo = midfiles[nSel].tempo;
		if (tempo)
			m_Tempo.Format("%d", 60000000 / tempo);
		m_Key = midfiles[nSel].key.c_str();
		m_Time = midfiles[nSel].time.c_str();
	}
	else	{
		m_Tempo.Empty();
		m_Key.Empty();
		m_Time.Empty();
	}
	UpdateData(FALSE);
}
void CJukeBoxDlg::OnChangeTempo() 
{
	if (IsWindow(m_Playlist.m_hWnd))	{
		int nSel = m_Playlist.GetCurSel();
		if (nSel != LB_ERR)	{
			UpdateData(TRUE);
			int t = m_Tempospin.GetPos();
			if (t >= mintempo && t <= maxtempo)	{
				midfiles[nSel].tempo = 60000000 / t;
				if (midiplay)
					midiplay->ChangeTempo(midfiles[nSel].tempo);
			}
		}
	}
}
