// JukeBoxDlg.h : header file
//

#if !defined(AFX_JUKEBOXDLG_H__A103A845_CF15_11D2_A77A_00C0A80034F0__INCLUDED_)
#define AFX_JUKEBOXDLG_H__A103A845_CF15_11D2_A77A_00C0A80034F0__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "stdafx.h"

struct midfiledata {
	std::string filename;
	std::string key;
	std::string time;
	long tempo;
	bool operator<(const midfiledata&) const
		{ return true; }
	bool operator==(const midfiledata&) const
		{ return true; }
};

class MIDIPlayer;

/////////////////////////////////////////////////////////////////////////////
// CJukeBoxDlg dialog
class CJukeBoxDlg : public CDialog
{
	bool isplaying;
	UINT devid;
	MIDIPlayer* midiplay;
	std::vector<midfiledata> midfiles;

	void AddFile(const std::string& file, unsigned int tmpo = 0);
	void StopSong();
	void StartSong();
	void PlayNextSong();
public:
	CJukeBoxDlg(CWnd* pParent = NULL);	// standard constructor
	~CJukeBoxDlg();

// Dialog Data
	//{{AFX_DATA(CJukeBoxDlg)
	enum { IDD = IDD_JUKEBOX_DIALOG };
	CSpinButtonCtrl	m_Seconds;
	CSpinButtonCtrl	m_Tempospin;
	CButton	m_Up;
	CButton	m_Down;
	CSpinButtonCtrl	m_Countoff;
	CListBox	m_Playlist;
	CButton	m_Play;
	CString	m_Key;
	CString	m_Time;
	BOOL	m_Metronome;
	CString	m_Tempo;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CJukeBoxDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CJukeBoxDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnDestroy();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnAddfile();
	afx_msg void OnSelchangePlaylist();
	afx_msg void OnPlay();
	afx_msg void OnClear();
	afx_msg void OnRemovefile();
	afx_msg void OnDblclkPlaylist();
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnMetronome();
	afx_msg void OnDown();
	afx_msg void OnUp();
	afx_msg void OnChangeTempo();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_JUKEBOXDLG_H__A103A845_CF15_11D2_A77A_00C0A80034F0__INCLUDED_)
