// --------- midiinfo.cpp
#include "stdafx.h"
#include "midiinfo.h"

// ----- convert SMF time format into displayable time format
void MIDIInfo::TimeSignature(Long delta,Short numer,Short denom,Short clocks,Short qnotes)
{
	time = '0' + numer;
	time += '/';
	time += '0' + pow(2, denom);
}
// ----- convert SMF key format into displayable key format
void MIDIInfo::KeySignature(Long delta,Short sharpflat,bool isminor)
{
	if (sharpflat >= -7 && sharpflat <= 7)	{
		sharpflat += 7;
		if (isminor)	{
			sharpflat += 3;
			if (sharpflat >= 15)
				sharpflat -= 15;
		}
		static char* Key[] = {
			"Cb","Gb","Db","Ab","Eb","Bb","F",
			"C",
			"G","D","A","E","B","F#","C#"
		};
		key = Key[sharpflat];
		if (isminor)
			key += " minor";
	}
}
