// ------ midiinfo.h
#ifndef MIDIINFO_H
#define MIDIINFO_H
#include "midifile.h"

class MIDIInfo : public MIDIFile	{
	std::string title;	// song title taken from text event 3
	long tempo;			// microseconds per quarter note
	std::string key;	// e.g. "F minor"
	std::string time;	// e.g. "3/4"
protected:
	void StartTrack(int trackno)
		{ if (trackno != 1) StopReading(); }
	void TextEvent(Long delta,Short event,Long length,const char* text)
		{ if (event == META_SEQTRKNAME) title = std::string(text, length); }
	void Tempo(Long delta, Long tmpo)
		{ tempo = tmpo; }
	void TimeSignature(Long delta,Short numer,Short denom,Short clocks,Short qnotes);
	void KeySignature(Long delta,Short sharpflat,bool isminor);
public:
	explicit MIDIInfo(std::ifstream& rFile) : MIDIFile (rFile) 
		{ tempo = 0; }
	const std::string& Title() const
		{ return title; }
	long Tempo() const
		{ return tempo; }
	const std::string& Key() const
		{ return key; }
	const std::string& Time() const
		{ return time; }
};
#endif
