// ---- midiplayer.cpp
#include "stdafx.h"
#include "midiplayer.h"

MIDIPlayer::MIDIPlayer(std::ifstream& rFile) : MIDIFile (rFile) 
{
	hMidiOut = 0;
	timer = 0;
	division = 5;
	owner = 0;
	ticking = false;
	countoff = 0;
	metronome = false;
	beatspermeasure = 4;
}
void MIDIPlayer::EndOfTrack(Long)
{
	if (track.size())	{
		// a track of realtime events has been accumulated, save it
		tracks.push_back(track);
		track.clear();
	}
}
void MIDIPlayer::TimeSignature(Long delta,Short numer,Short denom,Short clocks,Short qnotes)
{
	beatspermeasure = numer;
}
inline void MIDIPlayer::StoreEvent(const MIDIEvent& mev)
{
	delta += mev.delta;
	DWORD dwEvent  = mev.eventno | mev.channel | (mev.param1 << 8) | (mev.param2 << 16);
	MIDIData data = { delta, dwEvent };
	track.push_back(data);
}
void MIDIPlayer::NoteOn(Long delta,Short channel,Short note, Short velocity)
{
	MIDIEvent mev = { delta, MIDI_NOTEON, channel, note, velocity };
	StoreEvent(mev);
}
void MIDIPlayer::NoteOff(Long delta,Short channel,Short note, Short velocity)
{
	MIDIEvent mev = { delta, MIDI_NOTEOFF, channel, note, velocity };
	StoreEvent(mev);
}
void MIDIPlayer::Controller(Long delta,Short channel,Short controller, Short value)
{
	MIDIEvent mev = { delta, MIDI_CONTROL, channel, controller, value };
	StoreEvent(mev);
}
void MIDIPlayer::ProgramChange(Long delta,Short channel,Short program)
{
	MIDIEvent mev = { delta, MIDI_PROGRAM, channel, program, 0 };
	StoreEvent(mev);
}
MIDIPlayer* MIDIPlayer::pplay;
void CALLBACK TimerCallback(UINT, UINT, DWORD, DWORD, DWORD)
{
	MIDIPlayer::pplay->TimingMessage();
}
void MIDIPlayer::Play(long tmpo, int count, bool metr)
{
	if (midiOutOpen(&hMidiOut, MIDIMAPPER, 0, 0L, 0L) == 0)	{
		nticks = fticks = 0;	// integer representation of integral and fractional parts of clock
		period = 1;				// time slice in milliseconds
		clock = 0;				// accumulated time
		trtime = (period * 1000) * division;
		countoff = count * beatspermeasure + 1;
		metronome = metr;
		if (tmpo)
			ChangeTempo(tmpo);		// playing at a specified tempo
		divctr = 0;
		for (int i = 0; i < tracks.size(); i++)
			trkndx.push_back(0);
		pplay = this;
		ticking = false;
		timeGetDevCaps(&tc, sizeof tc);
		timeBeginPeriod(tc.wPeriodMin);
		timer = timeSetEvent(period, tc.wPeriodMin, TimerCallback, 0, TIME_PERIODIC);
		DWORD mmsg  = 0xfa;		//.start message
		midiOutShortMsg(hMidiOut, mmsg);
	}
}
void MIDIPlayer::TimingMessage()
{
	if (hMidiOut)	{
		ticking = true;
		// --- integral part of tick
		nticks = (fticks + trtime) / tempo;
		// --- fractional part of tick
		fticks += trtime - (nticks * tempo);
		// ---- process the count-off and the metronome
		if (divctr <= 0)	{
			// --- at a quarter note beat
			if (countoff)	{
				// --- in the count-off
				if (--countoff)	{
					DWORD ev  = MIDI_NOTEON | 9 | (37 << 8) | (80 << 16);
					midiOutShortMsg(hMidiOut, ev);
				}
			}
			if (countoff == 0 && metronome)	{
				// ---- play metronome (except during count-off)
				DWORD ev  = MIDI_NOTEON | 9 | (37 << 8) | (80 << 16);
				midiOutShortMsg(hMidiOut, ev);
			}
			divctr = division;
		}
		divctr -= nticks;
		if (countoff == 0)	{
			// ---- sequencer code
			bool stillplaying = false;
			// --- scan the tracks for realtime midi events due for playing
			for (int i = 0; i < tracks.size(); i++)	{
				// --- see if there are more events this track
				if (trkndx[i] < tracks[i].size())	{
					stillplaying = true;
					MIDIData& ev = tracks[i][trkndx[i]];
					while (ev.delta <= clock)	{
						// fire this event
						midiOutShortMsg(hMidiOut, ev.data);
						trkndx[i]++;
						if (trkndx[i] == tracks[i].size())
							break;
						ev = tracks[i][trkndx[i]];
					}
				}
			}
			if (!stillplaying)
				StopPlay();
			clock += nticks;
		}
		ticking = false;
	}
}
void MIDIPlayer::KillTimer()
{
	if (timer)	{
		timeKillEvent(timer);
		timer = 0;
		timeEndPeriod(tc.wPeriodMin);
	}
}
void MIDIPlayer::StopMIDI()
{
	if (hMidiOut)	{
		DWORD mmsg  = 0xfc;		// stop message
		midiOutShortMsg(hMidiOut, mmsg);
		midiOutClose(hMidiOut);
		hMidiOut = 0;
	}
}
void MIDIPlayer::StopPlay()
{
	KillTimer();
	StopMIDI();
	if (owner)
		owner->SendMessage(MM_MCINOTIFY, 0, 0);
}
void MIDIPlayer::Reset()
{
	KillTimer();
	while (ticking)	// wait for TimingMessage to return
		;
	if (hMidiOut)	{
		// --- all notes off, all channels
		DWORD ev;
		for (unsigned char channel = 0; channel < 16; channel++)	{
			ev = 0x7bb0 | channel;
			midiOutShortMsg(hMidiOut, ev);
		}
		ev = 0xff;	// system reset message
		midiOutShortMsg(hMidiOut, ev);
		StopMIDI();
	}
}
