// ----- midiplayer.h
#ifndef MIDIPLAYER_H
#define MIDIPLAYER_H
#include "stdafx.h"
#include "midiinfo.h"
// ---- realtime midi event data
struct MIDIEvent	{
	Long delta;
	Short eventno;
	Short channel;
	Short param1;
	Short param2;
};
// ---- midi event data ready for sequencing
struct MIDIData	{
	Long delta;		// delta time from beginning of sequence
	DWORD data;		// midi event packet
	// --- these are to let the type be contained in a std::vector
	bool operator<(const MIDIData&) const
		{ return true; }
	bool operator==(const MIDIData&) const
		{ return true; }
};
// ------- class for sequencing a Standard MIDI Format file
class MIDIPlayer : public MIDIFile	{
	long division;			// delta time ticks per quarter note
	CWnd* owner;			// window to notify when sequence is done
	// ----- the ticking clock variables
	long clock, period, nticks, fticks, trtime;
	Long delta;				// running delta time accumulation
	std::vector<MIDIData> track;	// track vector of events being gathered
	// --- vector of tracks
	std::vector<std::vector<MIDIData> > tracks;
	// --- vector of track event offsets
	std::vector<int> trkndx;
	HMIDIOUT hMidiOut;
	UINT timer;
	TIMECAPS tc;
	long tempo;				// microseconds per quarter note
	bool ticking;			// semaphore to wait for timing message function to complete
	int countoff;			// number of measures to count off
	bool metronome;			// true for metronome during playback
	int divctr;				// counts for metronome ticks
	int beatspermeasure;	// number of beats per measure (3, 4, ...)
	// --- overridden MIDIFile class functions
	void Header(Short fmt,Short trks,Short div)
		{ division = div; }
	void StartTrack(int trkno)
		{ delta = 0; }
	void EndOfTrack(Long delta);
	void TimeSignature(Long delta,Short numer,Short denom,Short clocks,Short qnotes);
	void NoteOn(Long delta,Short channel,Short note, Short velocity);
	void NoteOff(Long delta,Short channel,Short note, Short velocity);
	void Controller(Long delta,Short channel,Short controller, Short value);
	void ProgramChange(Long delta,Short channel,Short program);
	// ----- private member functions
	void StoreEvent(const MIDIEvent& mev);
	void KillTimer();
	void StopMIDI();
	// ----- timer mechanism
	friend void CALLBACK TimerCallback(UINT, UINT, DWORD, DWORD, DWORD);
	void TimingMessage();
	static MIDIPlayer* pplay;	// = "this" so TimerCallback can call TimingMessage
public:
	explicit MIDIPlayer(std::ifstream& rFile);
	// ---- play the SMF file with count measures of count-off, tempo of tmpo,
	//      and a metronome click if metr (if tmpo == 0, use the tempo from the SMF file)
	void Play(long tmpo, int count, bool metr);
	void StopPlay();				// stop playing the sequence
	void Reset();					// reset the midi system
	void RegisterWindow(CWnd* wnd)	// register a window to notify when sequence is done
		{ owner = wnd; }
	void Metronome(bool onoff)		// turn the metronome on or off
		{ metronome = onoff; }
	void ChangeTempo(long t)
		{ tempo = t; }
};
#endif
