#ifndef _PROFILER_HOOK_HEADER_
#define _PROFILER_HOOK_HEADER_

#include <iostream>
#include <map>
#include <algorithm>
#include <functional>
#include <vector>

using namespace std;

struct ClassItem
{ 
    char*   szClassName;
    long     size;
    long     count;

    ClassItem( JVMPI_Event *pEvent )
    {
        int event = pEvent->event_type & 0xffff; // Strip off modifier bits
        if( event != JVMPI_EVENT_CLASS_LOAD ) // We can only build from this event
            throw ClassItem::InvalidEventType();

        count = 0;
        size = 0;

        // Copy rather than reference the class name
        szClassName = new char[ strlen ( pEvent->u.class_load.class_name) ];
        strcpy( szClassName, pEvent->u.class_load.class_name );
    };

    ~ClassItem()
    {
        delete[] szClassName;
    }

    class InvalidEventType{};
};

struct ClassItemGreater : public binary_function<ClassItem*, ClassItem*, bool>
{
    bool operator()(const ClassItem* x, const ClassItem* y) const 
    {                                                  
        return x->size > y->size;
    }
};


typedef map<jobjectID, ClassItem*>  CLASSMAP;
typedef CLASSMAP::iterator          CLASSMAPITERATOR; 
typedef CLASSMAP::value_type        CLASSVALUE;

extern "C" void HandleEvent( JVMPI_Event *pEvent ); 



#endif