// Copyright (c) 1992-94 Silicon Graphics, Inc.
// Copyright (c) 1993-94 Fujitsu, Ltd.
//
// Permission to use, copy, modify, distribute, and sell this software and
// its documentation for any purpose is hereby granted without fee, provided
// that (i) the above copyright notices and this permission notice appear in
// all copies of the software and related documentation, and (ii) the name of
// Silicon Graphics and Fujitsu may not be used in any advertising or
// publicity relating to the software without the specific, prior written
// permission of Silicon Graphics and Fujitsu.
//
// THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
// EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
// WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
//
// IN NO EVENT SHALL SILICON GRAPHICS OR FUJITSU BE LIABLE FOR
// ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
// OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
// WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
// LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
// OF THIS SOFTWARE.
//

#include "DLoadLib.h"

#ifdef __powerc
#include <CodeFragments.h>
#include <Errors.h>
#include <Threads.h>
#include <Timer.h>
#endif

//#if defined(__hpux)
//#include <dl.h>
//#endif

#if defined(__sgi)
#include <malloc.h>
#endif

#if defined(WIN32)
#include <windows.h>
#define strdup _strdup
#endif

//
// Not sure what to do here if we don't have dlopen or something equivalent.
//

#if defined(__SVR4) || defined(__alpha) || defined(__linux) || defined(__sgi) || defined(__FreeBSD__)
#include <dlfcn.h>

dlhandle_t tjDLoadLib::load_library(const char* name) {
  return dlopen(name, RTLD_LAZY); //|RTLD_GLOBAL);
}

void* tjDLoadLib::get_symbol_address(const dlhandle_t h, const char *symbol) {
    return dlsym(h, symbol);
}

const char* tjDLoadLib::lib_prefix() { return "lib"; }
#if defined(__hpux)
const char* tjDLoadLib::lib_extension() { return ".sl"; }
#else
#if defined(WIN32)
const char* tjDLoadLib::lib_extension() { return ".dll"; }
#else
const char* tjDLoadLib::lib_extension() { return ".so"; }
#endif
#endif
const char* tjDLoadLib::load_error_msg() { return dlerror(); }

#endif

#if defined(WIN32)
#include <windows.h>

dlhandle_t tjDLoadLib::load_library(const char* name) {
    return LoadLibrary(name);
}

void* tjDLoadLib::get_symbol_address(const dlhandle_t h, const char *symbol) {
    return GetProcAddress(h, symbol);
}

const char* tjDLoadLib::lib_prefix() { return ""; }
const char* tjDLoadLib::lib_extension() { return ".dll"; }
const char* tjDLoadLib::load_error_msg() 
{
  DWORD errcode = GetLastError();
  LPVOID lpMsgBuf;

  FormatMessage( 
		FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
		NULL,
		GetLastError(),
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
		(LPTSTR) &lpMsgBuf,
		0,
		NULL 
		);
  
  // Free the buffer.
  LocalFree( lpMsgBuf );
  static char* str = 0;
  delete [] str;
  str = strcpy(new char[strlen((char*)lpMsgBuf)+1], (char*)lpMsgBuf);
  return (const char*)str; 
}

#endif

#if defined(__hpux)

dlhandle_t tjDLoadLib::load_library(const char* name) {
    return shl_load(name, BIND_DEFERRED | DYNAMIC_PATH, 0L);
}
void* tjDLoadLib::get_symbol_address(const dlhandle_t h, const char *symbol) {
    void* addr;
    int status;

    status = shl_findsym (&h, symbol, TYPE_PROCEDURE, &addr);
    return (status < 0) ? (void*)0 : addr;
}

const char* tjDLoadLib::lib_prefix() { return "lib"; }
const char* tjDLoadLib::lib_extension() { return ".sl"; }
const char* tjDLoadLib::load_error_msg() { return (const char*)0; }

#endif

#if defined(__sun) && !defined(__SVR4)
#include <dlfcn.h>


dlhandle_t tjDLoadLib::load_library(const char* name) {
    return dlopen(name, RTLD_LAZY);
}

void* tjDLoadLib::get_symbol_address(const dlhandle_t h, const char *symbol) {
    return dlsym(h, symbol);
}

const char* tjDLoadLib::lib_prefix() { return "lib"; }
const char* tjDLoadLib::lib_extension() { return ".so"; }
const char* tjDLoadLib::load_error_msg() { return dlerror(); }

#endif

#ifdef __powerc

dlhandle_t tjDLoadLib::load_library(const char* name) {
    Str63 libName;
    libName[0] = strlen(name);
    strcpy((char*) &libName[1], name);
    ConnectionID connID;
    Ptr mainAddr;
    Str255 errName;
    OSErr err = GetSharedLibrary(
        libName, kPowerPCArch, kLoadLib, &connID, &mainAddr, errName
    );
    return err == fragNoErr ? connID : 0;
}

void* tjDLoadLib::get_symbol_address(const dlhandle_t h, const char *symbol) {
    Str255 symName;
    symName[0] = strlen(symbol);
    strcpy((char*) &symName[1], symbol);
    Ptr symAddr;
    SymClass symClass;
    OSErr err = FindSymbol(h, symName, &symAddr, &symClass);
    return (void*) symAddr;
}

const char* tjDLoadLib::lib_prefix() { return ""; }
const char* tjDLoadLib::lib_extension() { return ".lib"; }
const char* tjDLoadLib::load_error_msg() { return (const char*)0; }

#endif
