// <begin copyright notice>
// ---------------------------------------------------------------------------
//
//                   Copyright (c) 1997 TargetJr Consortium
//               GE Corporate Research and Development (GE CRD)
//                             1 Research Circle
//                            Niskayuna, NY 12309
//                            All Rights Reserved
//              Reproduction rights limited as described below.
//                               
//      Permission to use, copy, modify, distribute, and sell this software
//      and its documentation for any purpose is hereby granted without fee,
//      provided that (i) the above copyright notice and this permission
//      notice appear in all copies of the software and related documentation,
//      (ii) the name TargetJr Consortium (represented by GE CRD), may not be
//      used in any advertising or publicity relating to the software without
//      the specific, prior written permission of GE CRD, and (iii) any
//      modifications are clearly marked and summarized in a change history
//      log.
//       
//      THE SOFTWARE IS PROVIDED "AS IS" AND WITHOUT WARRANTY OF ANY KIND,
//      EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
//      WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
//      IN NO EVENT SHALL THE TARGETJR CONSORTIUM BE LIABLE FOR ANY SPECIAL,
//      INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND OR ANY
//      DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
//      WHETHER OR NOT ADVISED OF THE POSSIBILITY OF SUCH DAMAGES, OR ON
//      ANY THEORY OF LIABILITY ARISING OUT OF OR IN CONNECTION WITH THE
//      USE OR PERFORMANCE OF THIS SOFTWARE.
//
// ---------------------------------------------------------------------------
// <end copyright notice>
#include "RunDynamicTests.h"
#include "DLoadLib.h"
#include <iostream.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>
#ifdef WIN32
#include <io.h>
#define _dup2 dup2
#include <winbase.h>
#include <stdio.h>
#else
#include <unistd.h>
#endif
#include <iostream.h>
#include <fstream.h>
#include <string>
#include <ctype.h>		// Include character processing macros
#define ANSI_NAME_SPACES
#ifdef ANSI_NAME_SPACES
#define string std::string
#endif

typedef void (* DL_FUNCTION)(int,char**);

// Stub function for setting break points, this
// function is called after the test case library
// is loaded, and before and code is executed.
 
void RunDynamicTests_Break()
{
}


char* c_downcase (char* s) {	// Convert entire string to lower case
  char* p = s;			// Point to beginning of string
  while (*p) {			// While there are still valid characters
    if (isupper (*p))		// if this is upper case
      *p = tolower (*p);	// convert to lowercase 
    p++;			// Advance pointer
  }
  return s;			// Return reference to modified string
}


// parse a file and count the number of times "passed" or "failed"
// shows up in the file.

static void passed_failed(int& pass, int& fail, string filename)
{
  string passed("passed");
  string failed("failed");
  char buff[1024];
  ifstream fin(filename.c_str());
  pass = 0;
  fail = 0;
  while(fin.getline(buff, 1023))
    {
      string str = c_downcase(buff);// case is not important
      if(str.find(passed) != string::npos)
	pass++;
      if(str.find(failed) != string::npos)
	fail++;
    }
}


// Special Code for Windows NT to avoid the 
// interactive box popping up in automated test cases

#ifdef WIN32
LONG WINAPI dynamic_test_exception_filter(struct _EXCEPTION_POINTERS *ExceptionInfo)
{
  PEXCEPTION_RECORD ExceptionRecord = ExceptionInfo->ExceptionRecord;
  DWORD ExceptionCode = ExceptionRecord->ExceptionCode;
  PVOID ExceptionAddress = ExceptionRecord->ExceptionAddress;

  cerr << endl
       << "An unhandled exception has occured while running the test."
       << endl;

  switch (ExceptionCode) {
  case EXCEPTION_ACCESS_VIOLATION :
    cerr << "EXCEPTION_ACCESS_VIOLATION";
    break;
  case EXCEPTION_BREAKPOINT :
    cerr << "EXCEPTION_BREAKPOINT";
    break;
  case EXCEPTION_DATATYPE_MISALIGNMENT :
    cerr << "EXCEPTION_DATATYPE_MISALIGNMENT";
    break;
  case EXCEPTION_SINGLE_STEP :
    cerr << "EXCEPTION_SINGLE_STEP";
    break;
  case EXCEPTION_ARRAY_BOUNDS_EXCEEDED :
    cerr << "EXCEPTION_ARRAY_BOUNDS_EXCEEDED";
    break;
  case EXCEPTION_FLT_DENORMAL_OPERAND :
    cerr << "EXCEPTION_FLT_DENORMAL_OPERAND";
    break;
  case EXCEPTION_FLT_DIVIDE_BY_ZERO :
    cerr << "EXCEPTION_FLT_DIVIDE_BY_ZERO";
    break;
  case EXCEPTION_FLT_INEXACT_RESULT :
    cerr << "EXCEPTION_FLT_INEXACT_RESULT";
    break;
  case EXCEPTION_FLT_INVALID_OPERATION :
    cerr << "EXCEPTION_FLT_INVALID_OPERATION";
    break;
  case EXCEPTION_FLT_OVERFLOW :
    cerr << "EXCEPTION_FLT_OVERFLOW";
    break;
  case EXCEPTION_FLT_STACK_CHECK :
    cerr << "EXCEPTION_FLT_STACK_CHECK";
    break;
  case EXCEPTION_FLT_UNDERFLOW :
    cerr << "EXCEPTION_FLT_UNDERFLOW";
    break;
  case EXCEPTION_INT_DIVIDE_BY_ZERO :
    cerr << "EXCEPTION_INT_DIVIDE_BY_ZERO";
    break;
  case EXCEPTION_INT_OVERFLOW :
    cerr << "EXCEPTION_INT_OVERFLOW";
    break;
  case EXCEPTION_PRIV_INSTRUCTION :
    cerr << "EXCEPTION_PRIV_INSTRUCTION";
    break;
  case EXCEPTION_NONCONTINUABLE_EXCEPTION :
    cerr << "EXCEPTION_NONCONTINUABLE_EXCEPTION";
    break;
  default :
    cerr << "ExceptionCode = " << ExceptionCode;
  } 

  cerr << " at address " << ExceptionAddress << endl;

  switch (ExceptionCode) {
  case EXCEPTION_ACCESS_VIOLATION :
    cerr << endl;
    if (ExceptionRecord->ExceptionInformation[0] == 0) {
      cerr << "The exception occured while trying to read from address "
           << (PVOID)(ExceptionRecord->ExceptionInformation[1])
           << endl;
    }
    else {
      cerr << "The exception occured while trying to write to address "
           << (PVOID)(ExceptionRecord->ExceptionInformation[1])
           << endl;
    }
    break;
  }

  return EXCEPTION_EXECUTE_HANDLER; 
}
#endif


// Run test with given arguments
// It is assumed that the first argument is the name of the 
// shared library containing the test case

int RunDynamicTests::RunTests(int argc, char** argv)
{
  bool stdout_stderr = false;

#ifdef WIN32
  // Disable the display of the general protection fault (GPF) message
  // box. 
  SetErrorMode(SEM_NOGPFAULTERRORBOX 
	       | SEM_FAILCRITICALERRORS
	       | SEM_NOGPFAULTERRORBOX
	       | SEM_NOOPENFILEERRORBOX);

  // Replace the top-level exception handler with our own. When an excepton
  // occurs in a process that is not being debuged, the replacement filter
  // will be used.
  SetUnhandledExceptionFilter(dynamic_test_exception_filter);
#endif

  for(int i=1; i < argc; i++)
    {
      string libname;
      string filename = argv[i];
      if(filename == "-")
	{
	  stdout_stderr = true;
	  continue;
	}
      
      libname = "./";
      libname += tjDLoadLib::lib_prefix();
      libname += filename;
      libname += tjDLoadLib::lib_extension();
      string outputfile = filename + ".out";
      int fd = -1;

      dlhandle_t library = tjDLoadLib::load_library(libname.c_str());
      if(!library)
	{
	  cerr << "error loading library " << libname.c_str() << endl;
	  const char* err = tjDLoadLib::load_error_msg();
	  if(err)
	    cerr << err << endl;
	  cerr << "FAILED: shared library problem " << endl;
	  close(fd);
	  continue;
	}
      // Redirect both standard out and error to an output file
      if(!stdout_stderr)
	{
	  fd = open(outputfile.c_str(), O_CREAT|O_RDWR|O_TRUNC, 0xffff);
	  dup2(fd, 1);
	  dup2(fd, 2);
	}

      // first try non mangled symbol
      string function_name = filename;
      DL_FUNCTION func = 
	(DL_FUNCTION)tjDLoadLib::get_symbol_address(library,
						    function_name.c_str());
      // try one underscore this is extern "C" with vc50
      if(!func)
	{
	  function_name = "_";
	  function_name += filename;
	  func = 
	    (DL_FUNCTION)tjDLoadLib::get_symbol_address(library,
							function_name.c_str());
	}
      bool name_mangled = false;
      // try name mangled symbols
      // report an error if this is used 
      // next try g++ names
      if(!func)
	{
	  function_name = filename + "__Fv";
	  name_mangled = true;
	  func = 
	    (DL_FUNCTION)tjDLoadLib::get_symbol_address(library, 
							function_name.c_str());
	}
      // SGI CC -32 mapping
      if(!func)
	{
	  function_name = filename + "__Gv";
	  name_mangled = true;
	  func = 
	    (DL_FUNCTION)tjDLoadLib::get_symbol_address(library, 
							function_name.c_str());
	}

      // visual c++ 5.0 name mangling 
      if(!func)
	{
	  function_name = "?";
	  function_name += filename;
	  function_name += "@@YAXXZ";
	  func = 
	    (DL_FUNCTION)tjDLoadLib::get_symbol_address(library, 
							function_name.c_str());
	  name_mangled = true;
	}

      if(!func)
	{
	  function_name = "__0FN";
	  function_name += filename;
	  function_name += "v";
	  cout << function_name.c_str() << endl;
	  func =
	    (DL_FUNCTION)tjDLoadLib::get_symbol_address(library,
							function_name.c_str());
	  name_mangled = true;
	}
      if(!func)
	{
	  cerr << "error getting symbol " << function_name.c_str() 
	       << "  from library " 
	       << libname.c_str() << endl;
	  if(tjDLoadLib::load_error_msg() )
	    cerr << tjDLoadLib::load_error_msg() << endl;
	  cerr << "FAILED: shared library problem " << endl;
	  close(fd);
	  continue;
	}
      if(name_mangled)
	cout << "WARNING: use extern \"C\" for function "
	     << filename.c_str()<<"()."<< endl;
      
      // Call break point function
      RunDynamicTests_Break();
      // Now call test function
      (*func)(argc-1, argv+1);
      
      // If stdout_stderr are not redirected to a file
      // then return now
      if(stdout_stderr)
	return 0;
      
      // If output directed to a file, count passed and failed
      // in the file, and create a test summary
      cout << "Test number " << i << " Complete " << filename.c_str() << endl;
      int passed = 0;
      int failed = 0;
      // count up the number of passed and failed tests
      passed_failed(passed, failed, outputfile);
      cout << "------------------------" << filename.c_str()
	   << "-SUMMARY---------------------------" << endl
	   << filename.c_str() << ": ";
      if (failed == 0)
        cout << "All " << passed << " tests passed\n";
      else if (failed == 1)
        cout << passed << " tests passed, 1 test failed ***\n";
      else
        cout << passed << " tests passed, " << failed << " tests failed ***\n";
      cout.flush();
      close(fd);
      close(1);
      close(2);
    }
  return 0;
}
