// <begin copyright notice>
// ---------------------------------------------------------------------------
//
//                   Copyright (c) 1997 TargetJr Consortium
//               GE Corporate Research and Development (GE CRD)
//                             1 Research Circle
//                            Niskayuna, NY 12309
//                            All Rights Reserved
//              Reproduction rights limited as described below.
//                               
//      Permission to use, copy, modify, distribute, and sell this software
//      and its documentation for any purpose is hereby granted without fee,
//      provided that (i) the above copyright notice and this permission
//      notice appear in all copies of the software and related documentation,
//      (ii) the name TargetJr Consortium (represented by GE CRD), may not be
//      used in any advertising or publicity relating to the software without
//      the specific, prior written permission of GE CRD, and (iii) any
//      modifications are clearly marked and summarized in a change history
//      log.
//       
//      THE SOFTWARE IS PROVIDED "AS IS" AND WITHOUT WARRANTY OF ANY KIND,
//      EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
//      WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
//      IN NO EVENT SHALL THE TARGETJR CONSORTIUM BE LIABLE FOR ANY SPECIAL,
//      INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND OR ANY
//      DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
//      WHETHER OR NOT ADVISED OF THE POSSIBILITY OF SUCH DAMAGES, OR ON
//      ANY THEORY OF LIABILITY ARISING OUT OF OR IN CONNECTION WITH THE
//      USE OR PERFORMANCE OF THIS SOFTWARE.
//
// ---------------------------------------------------------------------------
// <end copyright notice>
// Modifications:
//  200697 AWF Removed the force-load for static links.  It never worked, and
//             the makefile does it now.

#include "DLoadLib.h"
#include <iostream.h>
#include <string>

#define ANSI_NAME_SPACES
#ifdef ANSI_NAME_SPACES
#define string std::string
#endif
typedef int (* DL_FUNCTION)(int, char **);

// -- "C" linkage to make it easy to set breakpoints here.
extern "C" 
int cmain(int argc, char ** argv, DL_FUNCTION f)
{
  return (*f)(argc-1, argv+1);
}  

main(int argc, char ** argv)
{
  if (argc < 2) {
    cerr << "usage: tjrun <shared-library> <program-args>\n"; 
    cerr << " <shared-library> must contain a function called main\n";
    exit(1);
  }
 
  char *libname = argv[1];
  dlhandle_t library = tjDLoadLib::load_library(libname);
  if(!library) 
    {
    library = tjDLoadLib::load_library(string(string("./") + libname).c_str());
    if(!library)
      {
      cerr << "tjrun: error loading library " << libname << endl;
      cerr << tjDLoadLib::load_error_msg() << endl;
      return 1;
      }
    
    }
      
  string function_name = "main";
  DL_FUNCTION func = (DL_FUNCTION)tjDLoadLib::get_symbol_address(library, function_name.c_str());
  if (!func) {
    cerr << "tjrun: error getting symbol ``" << function_name.c_str() << "''  from library " << endl;
    cerr << tjDLoadLib::load_error_msg() << endl;
    return 2;
  }

  return cmain(argc, argv, func);
}
