// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called PETE (Portable Expression Template Engine) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-99-5.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No.  W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE, and to allow others to do so.
// The public may copy and use this SOFTWARE, FOR NONCOMMERCIAL USE ONLY,
// without charge, provided that this Notice and any statement of
// authorship are reproduced on all copies.  Neither the Government nor
// the University makes any warranty, express or implied, or assumes any
// liability or responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about PETE, send e-mail to pete@acl.lanl.gov,
// or visit the PETE web page at http://www.acl.lanl.gov/pete/.
// ----------------------------------------------------------------------
// ACL:license

#ifndef PETE_PETE_OPERATORTAGS_H
#define PETE_PETE_OPERATORTAGS_H

///////////////////////////////////////////////////////////////////////////////
//
// WARNING: THIS FILE WAS GENERATED AUTOMATICALLY!
// YOU SHOULD MODIFY THE INPUT FILES INSTEAD OF CHANGING THIS FILE DIRECTLY!
//
// THE FOLLOWING INPUT FILES WERE USED TO MAKE THIS FILE:
//
// MakeOperators
// PeteOps.in
//
///////////////////////////////////////////////////////////////////////////////


struct FnArcCos
{
  FnArcCos() { }
  FnArcCos(const FnArcCos&) { }
  enum { tag = UnaryPassThruTag };
  template<class T>
  inline typename UnaryReturn<T, FnArcCos>::Type_t
  operator()(const T &a) const
  {
    return (acos(a));
  }
};

struct FnArcSin
{
  FnArcSin() { }
  FnArcSin(const FnArcSin&) { }
  enum { tag = UnaryPassThruTag };
  template<class T>
  inline typename UnaryReturn<T, FnArcSin>::Type_t
  operator()(const T &a) const
  {
    return (asin(a));
  }
};

struct FnArcTan
{
  FnArcTan() { }
  FnArcTan(const FnArcTan&) { }
  enum { tag = UnaryPassThruTag };
  template<class T>
  inline typename UnaryReturn<T, FnArcTan>::Type_t
  operator()(const T &a) const
  {
    return (atan(a));
  }
};

struct FnCeil
{
  FnCeil() { }
  FnCeil(const FnCeil&) { }
  enum { tag = UnaryPassThruTag };
  template<class T>
  inline typename UnaryReturn<T, FnCeil>::Type_t
  operator()(const T &a) const
  {
    return (ceil(a));
  }
};

struct FnCos
{
  FnCos() { }
  FnCos(const FnCos&) { }
  enum { tag = UnaryPassThruTag };
  template<class T>
  inline typename UnaryReturn<T, FnCos>::Type_t
  operator()(const T &a) const
  {
    return (cos(a));
  }
};

struct FnHypCos
{
  FnHypCos() { }
  FnHypCos(const FnHypCos&) { }
  enum { tag = UnaryPassThruTag };
  template<class T>
  inline typename UnaryReturn<T, FnHypCos>::Type_t
  operator()(const T &a) const
  {
    return (cosh(a));
  }
};

struct FnExp
{
  FnExp() { }
  FnExp(const FnExp&) { }
  enum { tag = UnaryPassThruTag };
  template<class T>
  inline typename UnaryReturn<T, FnExp>::Type_t
  operator()(const T &a) const
  {
    return (exp(a));
  }
};

struct FnFabs
{
  FnFabs() { }
  FnFabs(const FnFabs&) { }
  enum { tag = UnaryPassThruTag };
  template<class T>
  inline typename UnaryReturn<T, FnFabs>::Type_t
  operator()(const T &a) const
  {
    return (fabs(a));
  }
};

struct FnFloor
{
  FnFloor() { }
  FnFloor(const FnFloor&) { }
  enum { tag = UnaryPassThruTag };
  template<class T>
  inline typename UnaryReturn<T, FnFloor>::Type_t
  operator()(const T &a) const
  {
    return (floor(a));
  }
};

struct FnLog
{
  FnLog() { }
  FnLog(const FnLog&) { }
  enum { tag = UnaryPassThruTag };
  template<class T>
  inline typename UnaryReturn<T, FnLog>::Type_t
  operator()(const T &a) const
  {
    return (log(a));
  }
};

struct FnLog10
{
  FnLog10() { }
  FnLog10(const FnLog10&) { }
  enum { tag = UnaryPassThruTag };
  template<class T>
  inline typename UnaryReturn<T, FnLog10>::Type_t
  operator()(const T &a) const
  {
    return (log10(a));
  }
};

struct FnSin
{
  FnSin() { }
  FnSin(const FnSin&) { }
  enum { tag = UnaryPassThruTag };
  template<class T>
  inline typename UnaryReturn<T, FnSin>::Type_t
  operator()(const T &a) const
  {
    return (sin(a));
  }
};

struct FnHypSin
{
  FnHypSin() { }
  FnHypSin(const FnHypSin&) { }
  enum { tag = UnaryPassThruTag };
  template<class T>
  inline typename UnaryReturn<T, FnHypSin>::Type_t
  operator()(const T &a) const
  {
    return (sinh(a));
  }
};

struct FnSqrt
{
  FnSqrt() { }
  FnSqrt(const FnSqrt&) { }
  enum { tag = UnaryPassThruTag };
  template<class T>
  inline typename UnaryReturn<T, FnSqrt>::Type_t
  operator()(const T &a) const
  {
    return (sqrt(a));
  }
};

struct FnTan
{
  FnTan() { }
  FnTan(const FnTan&) { }
  enum { tag = UnaryPassThruTag };
  template<class T>
  inline typename UnaryReturn<T, FnTan>::Type_t
  operator()(const T &a) const
  {
    return (tan(a));
  }
};

struct FnHypTan
{
  FnHypTan() { }
  FnHypTan(const FnHypTan&) { }
  enum { tag = UnaryPassThruTag };
  template<class T>
  inline typename UnaryReturn<T, FnHypTan>::Type_t
  operator()(const T &a) const
  {
    return (tanh(a));
  }
};

struct OpUnaryMinus
{
  OpUnaryMinus() { }
  OpUnaryMinus(const OpUnaryMinus&) { }
  enum { tag = UnaryPassThruTag };
  template<class T>
  inline typename UnaryReturn<T, OpUnaryMinus>::Type_t
  operator()(const T &a) const
  {
    return (-a);
  }
};

struct OpUnaryPlus
{
  OpUnaryPlus() { }
  OpUnaryPlus(const OpUnaryPlus&) { }
  enum { tag = UnaryPassThruTag };
  template<class T>
  inline typename UnaryReturn<T, OpUnaryPlus>::Type_t
  operator()(const T &a) const
  {
    return (+a);
  }
};

struct OpBitwiseNot
{
  OpBitwiseNot() { }
  OpBitwiseNot(const OpBitwiseNot&) { }
  enum { tag = UnaryPassThruTag };
  template<class T>
  inline typename UnaryReturn<T, OpBitwiseNot>::Type_t
  operator()(const T &a) const
  {
    return (~a);
  }
};

struct OpIdentity
{
  OpIdentity() { }
  OpIdentity(const OpIdentity&) { }
  enum { tag = UnaryPassThruTag };
  template<class T>
  inline typename UnaryReturn<T, OpIdentity>::Type_t
  operator()(const T &a) const
  {
    return (a);
  }
};

struct OpNot
{
  OpNot() { }
  OpNot(const OpNot&) { }
  typedef bool Type_t;
  enum { tag = Type2Index<bool>::val };
  template<class T>
  inline typename UnaryReturn<T, OpNot>::Type_t
  operator()(const T &a) const
  {
    return (!a);
  }
};

template <class T1>
struct OpCast
{
  OpCast() { }
  OpCast(const OpCast<T1>&) { }
  typedef T1 Type_t;
  enum { tag = Type2Index<T1>::val };
  template<class T2>
  inline T1 operator()(const T2 &a) const
  {
    return T1(a);
  }
};

struct OpAdd
{
  OpAdd() { }
  OpAdd(const OpAdd&) { }
  enum { tag = BinaryPromoteTag };
  template<class T1, class T2>
  inline typename BinaryReturn<T1, T2, OpAdd>::Type_t
  operator()(const T1 &a, const T2 &b) const
  {
    return (a + b);
  }
};

struct OpSubtract
{
  OpSubtract() { }
  OpSubtract(const OpSubtract&) { }
  enum { tag = BinaryPromoteTag };
  template<class T1, class T2>
  inline typename BinaryReturn<T1, T2, OpSubtract>::Type_t
  operator()(const T1 &a, const T2 &b) const
  {
    return (a - b);
  }
};

struct OpMultiply
{
  OpMultiply() { }
  OpMultiply(const OpMultiply&) { }
  enum { tag = BinaryPromoteTag };
  template<class T1, class T2>
  inline typename BinaryReturn<T1, T2, OpMultiply>::Type_t
  operator()(const T1 &a, const T2 &b) const
  {
    return (a * b);
  }
};

struct OpDivide
{
  OpDivide() { }
  OpDivide(const OpDivide&) { }
  enum { tag = BinaryPromoteTag };
  template<class T1, class T2>
  inline typename BinaryReturn<T1, T2, OpDivide>::Type_t
  operator()(const T1 &a, const T2 &b) const
  {
    return (a / b);
  }
};

struct OpMod
{
  OpMod() { }
  OpMod(const OpMod&) { }
  enum { tag = BinaryPromoteTag };
  template<class T1, class T2>
  inline typename BinaryReturn<T1, T2, OpMod>::Type_t
  operator()(const T1 &a, const T2 &b) const
  {
    return (a % b);
  }
};

struct OpBitwiseAnd
{
  OpBitwiseAnd() { }
  OpBitwiseAnd(const OpBitwiseAnd&) { }
  enum { tag = BinaryPromoteTag };
  template<class T1, class T2>
  inline typename BinaryReturn<T1, T2, OpBitwiseAnd>::Type_t
  operator()(const T1 &a, const T2 &b) const
  {
    return (a & b);
  }
};

struct OpBitwiseOr
{
  OpBitwiseOr() { }
  OpBitwiseOr(const OpBitwiseOr&) { }
  enum { tag = BinaryPromoteTag };
  template<class T1, class T2>
  inline typename BinaryReturn<T1, T2, OpBitwiseOr>::Type_t
  operator()(const T1 &a, const T2 &b) const
  {
    return (a | b);
  }
};

struct OpBitwiseXor
{
  OpBitwiseXor() { }
  OpBitwiseXor(const OpBitwiseXor&) { }
  enum { tag = BinaryPromoteTag };
  template<class T1, class T2>
  inline typename BinaryReturn<T1, T2, OpBitwiseXor>::Type_t
  operator()(const T1 &a, const T2 &b) const
  {
    return (a ^ b);
  }
};

struct FnLdexp
{
  FnLdexp() { }
  FnLdexp(const FnLdexp&) { }
  enum { tag = BinaryPromoteTag };
  template<class T1, class T2>
  inline typename BinaryReturn<T1, T2, FnLdexp>::Type_t
  operator()(const T1 &a, const T2 &b) const
  {
    return (ldexp(a,b));
  }
};

struct FnPow
{
  FnPow() { }
  FnPow(const FnPow&) { }
  enum { tag = BinaryPromoteTag };
  template<class T1, class T2>
  inline typename BinaryReturn<T1, T2, FnPow>::Type_t
  operator()(const T1 &a, const T2 &b) const
  {
    return (pow(a,b));
  }
};

struct FnFmod
{
  FnFmod() { }
  FnFmod(const FnFmod&) { }
  enum { tag = BinaryPromoteTag };
  template<class T1, class T2>
  inline typename BinaryReturn<T1, T2, FnFmod>::Type_t
  operator()(const T1 &a, const T2 &b) const
  {
    return (fmod(a,b));
  }
};

struct FnArcTan2
{
  FnArcTan2() { }
  FnArcTan2(const FnArcTan2&) { }
  enum { tag = BinaryPromoteTag };
  template<class T1, class T2>
  inline typename BinaryReturn<T1, T2, FnArcTan2>::Type_t
  operator()(const T1 &a, const T2 &b) const
  {
    return (atan2(a,b));
  }
};

struct OpLT
{
  OpLT() { }
  OpLT(const OpLT&) { }
  typedef bool Type_t;
  enum { tag = Type2Index<bool>::val };
  template<class T1, class T2>
  inline typename BinaryReturn<T1, T2, OpLT>::Type_t
  operator()(const T1 &a, const T2 &b) const
  {
    return (a < b);
  }
};

struct OpLE
{
  OpLE() { }
  OpLE(const OpLE&) { }
  typedef bool Type_t;
  enum { tag = Type2Index<bool>::val };
  template<class T1, class T2>
  inline typename BinaryReturn<T1, T2, OpLE>::Type_t
  operator()(const T1 &a, const T2 &b) const
  {
    return (a <= b);
  }
};

struct OpGT
{
  OpGT() { }
  OpGT(const OpGT&) { }
  typedef bool Type_t;
  enum { tag = Type2Index<bool>::val };
  template<class T1, class T2>
  inline typename BinaryReturn<T1, T2, OpGT>::Type_t
  operator()(const T1 &a, const T2 &b) const
  {
    return (a > b);
  }
};

struct OpGE
{
  OpGE() { }
  OpGE(const OpGE&) { }
  typedef bool Type_t;
  enum { tag = Type2Index<bool>::val };
  template<class T1, class T2>
  inline typename BinaryReturn<T1, T2, OpGE>::Type_t
  operator()(const T1 &a, const T2 &b) const
  {
    return (a >= b);
  }
};

struct OpEQ
{
  OpEQ() { }
  OpEQ(const OpEQ&) { }
  typedef bool Type_t;
  enum { tag = Type2Index<bool>::val };
  template<class T1, class T2>
  inline typename BinaryReturn<T1, T2, OpEQ>::Type_t
  operator()(const T1 &a, const T2 &b) const
  {
    return (a == b);
  }
};

struct OpNE
{
  OpNE() { }
  OpNE(const OpNE&) { }
  typedef bool Type_t;
  enum { tag = Type2Index<bool>::val };
  template<class T1, class T2>
  inline typename BinaryReturn<T1, T2, OpNE>::Type_t
  operator()(const T1 &a, const T2 &b) const
  {
    return (a != b);
  }
};

struct OpAnd
{
  OpAnd() { }
  OpAnd(const OpAnd&) { }
  typedef bool Type_t;
  enum { tag = Type2Index<bool>::val };
  template<class T1, class T2>
  inline typename BinaryReturn<T1, T2, OpAnd>::Type_t
  operator()(const T1 &a, const T2 &b) const
  {
    return (a && b);
  }
};

struct OpOr
{
  OpOr() { }
  OpOr(const OpOr&) { }
  typedef bool Type_t;
  enum { tag = Type2Index<bool>::val };
  template<class T1, class T2>
  inline typename BinaryReturn<T1, T2, OpOr>::Type_t
  operator()(const T1 &a, const T2 &b) const
  {
    return (a || b);
  }
};

struct OpLeftShift
{
  OpLeftShift() { }
  OpLeftShift(const OpLeftShift&) { }
  enum { tag = BinaryUseLeftTag };
  template<class T1, class T2>
  inline typename BinaryReturn<T1, T2, OpLeftShift>::Type_t
  operator()(const T1 &a, const T2 &b) const
  {
    return (a << b);
  }
};

struct OpRightShift
{
  OpRightShift() { }
  OpRightShift(const OpRightShift&) { }
  enum { tag = BinaryUseLeftTag };
  template<class T1, class T2>
  inline typename BinaryReturn<T1, T2, OpRightShift>::Type_t
  operator()(const T1 &a, const T2 &b) const
  {
    return (a >> b);
  }
};

struct OpAddAssign
{
  OpAddAssign() { }
  OpAddAssign(const OpAddAssign&) { }
  enum { tag = BinaryUseLeftTag };
  template<class T1, class T2>
  inline typename BinaryReturn<T1, T2, OpAddAssign>::Type_t
  operator()(T1 &a, const T2 &b) const
  {
    return (a += b);
  }
};

struct OpSubtractAssign
{
  OpSubtractAssign() { }
  OpSubtractAssign(const OpSubtractAssign&) { }
  enum { tag = BinaryUseLeftTag };
  template<class T1, class T2>
  inline typename BinaryReturn<T1, T2, OpSubtractAssign>::Type_t
  operator()(T1 &a, const T2 &b) const
  {
    return (a -= b);
  }
};

struct OpMultiplyAssign
{
  OpMultiplyAssign() { }
  OpMultiplyAssign(const OpMultiplyAssign&) { }
  enum { tag = BinaryUseLeftTag };
  template<class T1, class T2>
  inline typename BinaryReturn<T1, T2, OpMultiplyAssign>::Type_t
  operator()(T1 &a, const T2 &b) const
  {
    return (a *= b);
  }
};

struct OpDivideAssign
{
  OpDivideAssign() { }
  OpDivideAssign(const OpDivideAssign&) { }
  enum { tag = BinaryUseLeftTag };
  template<class T1, class T2>
  inline typename BinaryReturn<T1, T2, OpDivideAssign>::Type_t
  operator()(T1 &a, const T2 &b) const
  {
    return (a /= b);
  }
};

struct OpModAssign
{
  OpModAssign() { }
  OpModAssign(const OpModAssign&) { }
  enum { tag = BinaryUseLeftTag };
  template<class T1, class T2>
  inline typename BinaryReturn<T1, T2, OpModAssign>::Type_t
  operator()(T1 &a, const T2 &b) const
  {
    return (a %= b);
  }
};

struct OpBitwiseOrAssign
{
  OpBitwiseOrAssign() { }
  OpBitwiseOrAssign(const OpBitwiseOrAssign&) { }
  enum { tag = BinaryUseLeftTag };
  template<class T1, class T2>
  inline typename BinaryReturn<T1, T2, OpBitwiseOrAssign>::Type_t
  operator()(T1 &a, const T2 &b) const
  {
    return (a |= b);
  }
};

struct OpBitwiseAndAssign
{
  OpBitwiseAndAssign() { }
  OpBitwiseAndAssign(const OpBitwiseAndAssign&) { }
  enum { tag = BinaryUseLeftTag };
  template<class T1, class T2>
  inline typename BinaryReturn<T1, T2, OpBitwiseAndAssign>::Type_t
  operator()(T1 &a, const T2 &b) const
  {
    return (a &= b);
  }
};

struct OpBitwiseXorAssign
{
  OpBitwiseXorAssign() { }
  OpBitwiseXorAssign(const OpBitwiseXorAssign&) { }
  enum { tag = BinaryUseLeftTag };
  template<class T1, class T2>
  inline typename BinaryReturn<T1, T2, OpBitwiseXorAssign>::Type_t
  operator()(T1 &a, const T2 &b) const
  {
    return (a ^= b);
  }
};

struct OpLeftShiftAssign
{
  OpLeftShiftAssign() { }
  OpLeftShiftAssign(const OpLeftShiftAssign&) { }
  enum { tag = BinaryUseLeftTag };
  template<class T1, class T2>
  inline typename BinaryReturn<T1, T2, OpLeftShiftAssign>::Type_t
  operator()(T1 &a, const T2 &b) const
  {
    return (a <<= b);
  }
};

struct OpRightShiftAssign
{
  OpRightShiftAssign() { }
  OpRightShiftAssign(const OpRightShiftAssign&) { }
  enum { tag = BinaryUseLeftTag };
  template<class T1, class T2>
  inline typename BinaryReturn<T1, T2, OpRightShiftAssign>::Type_t
  operator()(T1 &a, const T2 &b) const
  {
    return (a >>= b);
  }
};

struct OpAssign
{
  OpAssign() { }
  OpAssign(const OpAssign&) { }
  enum { tag = BinaryUseLeftTag };
  template<class T1, class T2>
  inline typename BinaryReturn<T1, T2, OpAssign>::Type_t
  operator()(T1 &a, const T2 &b) const
  {
    return (a = b);
  }
};

struct FnWhere
{
  FnWhere() { }
  FnWhere(const FnWhere&) { }
  enum { tag = BinaryPromoteTag };
  template<class T1, class T2, class T3>
  inline typename TrinaryReturn<T1, T2, T3, FnWhere>::Type_t
  operator()(const T1 &a, const T2 &b,const T3 &c) const
  {
    return (a ? b : c);
  }
};

#endif // PETE_PETE_OPERATORTAGS_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: OperatorTags.h,v $   $Author: sa_smith $
// $Revision: 1.4 $   $Date: 1999/02/03 21:41:44 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
