// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called PETE (Portable Expression Template Engine) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-99-5.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No.  W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE, and to allow others to do so.
// The public may copy and use this SOFTWARE, FOR NONCOMMERCIAL USE ONLY,
// without charge, provided that this Notice and any statement of
// authorship are reproduced on all copies.  Neither the Government nor
// the University makes any warranty, express or implied, or assumes any
// liability or responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about PETE, send e-mail to pete@acl.lanl.gov,
// or visit the PETE web page at http://www.acl.lanl.gov/pete/.
// ----------------------------------------------------------------------
// ACL:license

#ifndef PETE_SRC_TOOLS_OPERATORDESCRIPTOR_H
#define PETE_SRC_TOOLS_OPERATORDESCRIPTOR_H

#include <string>
using std::string;
#include <iostream.h>

class OperatorDescriptor {
public:

  //---------------------------------------------------------------------------
  // Constructors: specify control strings or copy from another 
  // OperatorDescriptor.

  OperatorDescriptor(const string &tag, const string &func, const string &expr)
  : tag_m(tag), func_m(func), expr_m(expr)
  { }
  
  OperatorDescriptor(const OperatorDescriptor &model)
  : tag_m(model.tag_m), 
    func_m(model.func_m),
    expr_m(model.expr_m)
  { }

  //---------------------------------------------------------------------------
  // Trivial destructor. 
  
  OperatorDescriptor() { }
  
  //---------------------------------------------------------------------------
  // Copy-assignment operator: just copy members. 

  OperatorDescriptor &operator=(const OperatorDescriptor &rhs)
  {
    tag_m = rhs.tag_m;
    func_m = rhs.func_m;
    expr_m = rhs.expr_m;
    
    return *this;
  }
  
  //---------------------------------------------------------------------------
  // Return strings. 

  const string &tag() const
  {
    return tag_m;
  }

  const string &function() const
  {
    return func_m;
  }

  const string &expression() const
  {
    return expr_m;
  }
  
private:

  string tag_m, func_m, expr_m;

};

inline ostream &operator<<(ostream &os, const OperatorDescriptor &o)
{
  os << "TAG  = " << o.tag() << endl;
  os << "FUNC = " << o.function() << endl;
  os << "EXPR = " << o.expression() << endl;
  
  return os;
}
  
#endif // PETE_SRC_TOOLS_OPERATORDESCRIPTOR_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: OperatorDescriptor.h,v $   $Author: sa_smith $
// $Revision: 1.5 $   $Date: 1999/02/03 21:40:04 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
