// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called PETE (Portable Expression Template Engine) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-99-5.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No.  W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE, and to allow others to do so.
// The public may copy and use this SOFTWARE, FOR NONCOMMERCIAL USE ONLY,
// without charge, provided that this Notice and any statement of
// authorship are reproduced on all copies.  Neither the Government nor
// the University makes any warranty, express or implied, or assumes any
// liability or responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about PETE, send e-mail to pete@acl.lanl.gov,
// or visit the PETE web page at http://www.acl.lanl.gov/pete/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// Functions:
// flagOption
// stringOption
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Include Files
//-----------------------------------------------------------------------------

#include "Options.h"
#include <string>
#include <iostream.h>
#include <stdlib.h>

bool flagOption(int argc,char ** argv,const string &option)
{
  // Scan through the arguments.

  int i;
  for (i=1;i<argc;++i)
  {
    if (std::string(argv[i]) == std::string(option))
      return true;
  }

  return false;
}

string stringOption(int argc,char ** argv,
		    const string &option,const string &def)
{
  // Scan through the arguments.

  int i;
  for (i=1;i<argc;++i)
  {
    if (std::string(argv[i]) == std::string(option))
    {
      if (i+1<argc)
	return string(argv[i+1]);
    }
  }

  return def;
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: Options.cpp,v $   $Author: sa_smith $
// $Revision: 1.3 $   $Date: 1999/02/03 21:40:04 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
