// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called PETE (Portable Expression Template Engine) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-99-5.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No.  W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE, and to allow others to do so.
// The public may copy and use this SOFTWARE, FOR NONCOMMERCIAL USE ONLY,
// without charge, provided that this Notice and any statement of
// authorship are reproduced on all copies.  Neither the Government nor
// the University makes any warranty, express or implied, or assumes any
// liability or responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about PETE, send e-mail to pete@acl.lanl.gov,
// or visit the PETE web page at http://www.acl.lanl.gov/pete/.
// ----------------------------------------------------------------------
// ACL:license

///////////////////////////////////////////////////////////////////////////////
//
// WARNING: THIS FILE WAS GENERATED AUTOMATICALLY!
// YOU SHOULD MODIFY THE INPUT FILES INSTEAD OF CHANGING THIS FILE DIRECTLY!
//
// THE FOLLOWING INPUT FILES WERE USED TO MAKE THIS FILE:
//
// MakePeteOpsData
// PeteOps.in
//
///////////////////////////////////////////////////////////////////////////////

#include "Tools/OperatorDescriptor.h"
#include <vector.h>
#include <map.h>

void peteOps(map<string,vector<OperatorDescriptor> > &m)
{
  m["assignOp"].push_back(
              OperatorDescriptor("OpAssign",
                                 "assign",
                                 "(a = b)"));
  m["binaryAssignOps"].push_back(
              OperatorDescriptor("OpAddAssign",
                                 "operator+=",
                                 "(a += b)"));
  m["binaryAssignOps"].push_back(
              OperatorDescriptor("OpSubtractAssign",
                                 "operator-=",
                                 "(a -= b)"));
  m["binaryAssignOps"].push_back(
              OperatorDescriptor("OpMultiplyAssign",
                                 "operator*=",
                                 "(a *= b)"));
  m["binaryAssignOps"].push_back(
              OperatorDescriptor("OpDivideAssign",
                                 "operator/=",
                                 "(a /= b)"));
  m["binaryAssignOps"].push_back(
              OperatorDescriptor("OpModAssign",
                                 "operator%=",
                                 "(a %= b)"));
  m["binaryAssignOps"].push_back(
              OperatorDescriptor("OpBitwiseOrAssign",
                                 "operator|=",
                                 "(a |= b)"));
  m["binaryAssignOps"].push_back(
              OperatorDescriptor("OpBitwiseAndAssign",
                                 "operator&=",
                                 "(a &= b)"));
  m["binaryAssignOps"].push_back(
              OperatorDescriptor("OpBitwiseXorAssign",
                                 "operator^=",
                                 "(a ^= b)"));
  m["binaryAssignOps"].push_back(
              OperatorDescriptor("OpLeftShiftAssign",
                                 "operator<<=",
                                 "(a <<= b)"));
  m["binaryAssignOps"].push_back(
              OperatorDescriptor("OpRightShiftAssign",
                                 "operator>>=",
                                 "(a >>= b)"));
  m["binaryBoolOps"].push_back(
              OperatorDescriptor("OpLT",
                                 "operator<",
                                 "(a < b)"));
  m["binaryBoolOps"].push_back(
              OperatorDescriptor("OpLE",
                                 "operator<=",
                                 "(a <= b)"));
  m["binaryBoolOps"].push_back(
              OperatorDescriptor("OpGT",
                                 "operator>",
                                 "(a > b)"));
  m["binaryBoolOps"].push_back(
              OperatorDescriptor("OpGE",
                                 "operator>=",
                                 "(a >= b)"));
  m["binaryBoolOps"].push_back(
              OperatorDescriptor("OpEQ",
                                 "operator==",
                                 "(a == b)"));
  m["binaryBoolOps"].push_back(
              OperatorDescriptor("OpNE",
                                 "operator!=",
                                 "(a != b)"));
  m["binaryBoolOps"].push_back(
              OperatorDescriptor("OpAnd",
                                 "operator&&",
                                 "(a && b)"));
  m["binaryBoolOps"].push_back(
              OperatorDescriptor("OpOr",
                                 "operator||",
                                 "(a || b)"));
  m["binaryLeftOps"].push_back(
              OperatorDescriptor("OpLeftShift",
                                 "operator<<",
                                 "(a << b)"));
  m["binaryLeftOps"].push_back(
              OperatorDescriptor("OpRightShift",
                                 "operator>>",
                                 "(a >> b)"));
  m["binaryOps"].push_back(
              OperatorDescriptor("OpAdd",
                                 "operator+",
                                 "(a + b)"));
  m["binaryOps"].push_back(
              OperatorDescriptor("OpSubtract",
                                 "operator-",
                                 "(a - b)"));
  m["binaryOps"].push_back(
              OperatorDescriptor("OpMultiply",
                                 "operator*",
                                 "(a * b)"));
  m["binaryOps"].push_back(
              OperatorDescriptor("OpDivide",
                                 "operator/",
                                 "(a / b)"));
  m["binaryOps"].push_back(
              OperatorDescriptor("OpMod",
                                 "operator%",
                                 "(a % b)"));
  m["binaryOps"].push_back(
              OperatorDescriptor("OpBitwiseAnd",
                                 "operator&",
                                 "(a & b)"));
  m["binaryOps"].push_back(
              OperatorDescriptor("OpBitwiseOr",
                                 "operator|",
                                 "(a | b)"));
  m["binaryOps"].push_back(
              OperatorDescriptor("OpBitwiseXor",
                                 "operator^",
                                 "(a ^ b)"));
  m["binaryOps"].push_back(
              OperatorDescriptor("FnLdexp",
                                 "ldexp",
                                 "(ldexp(a,b))"));
  m["binaryOps"].push_back(
              OperatorDescriptor("FnPow",
                                 "pow",
                                 "(pow(a,b))"));
  m["binaryOps"].push_back(
              OperatorDescriptor("FnFmod",
                                 "fmod",
                                 "(fmod(a,b))"));
  m["binaryOps"].push_back(
              OperatorDescriptor("FnArcTan2",
                                 "atan2",
                                 "(atan2(a,b))"));
  m["trinaryOps"].push_back(
              OperatorDescriptor("FnWhere",
                                 "where",
                                 "(a ? b : c)"));
  m["unaryBoolOps"].push_back(
              OperatorDescriptor("OpNot",
                                 "operator!",
                                 "(!a)"));
  m["unaryCastOps"].push_back(
              OperatorDescriptor("OpCast",
                                 "peteCast",
                                 "T1(a)"));
  m["unaryOps"].push_back(
              OperatorDescriptor("FnArcCos",
                                 "acos",
                                 "(acos(a))"));
  m["unaryOps"].push_back(
              OperatorDescriptor("FnArcSin",
                                 "asin",
                                 "(asin(a))"));
  m["unaryOps"].push_back(
              OperatorDescriptor("FnArcTan",
                                 "atan",
                                 "(atan(a))"));
  m["unaryOps"].push_back(
              OperatorDescriptor("FnCeil",
                                 "ceil",
                                 "(ceil(a))"));
  m["unaryOps"].push_back(
              OperatorDescriptor("FnCos",
                                 "cos",
                                 "(cos(a))"));
  m["unaryOps"].push_back(
              OperatorDescriptor("FnHypCos",
                                 "cosh",
                                 "(cosh(a))"));
  m["unaryOps"].push_back(
              OperatorDescriptor("FnExp",
                                 "exp",
                                 "(exp(a))"));
  m["unaryOps"].push_back(
              OperatorDescriptor("FnFabs",
                                 "fabs",
                                 "(fabs(a))"));
  m["unaryOps"].push_back(
              OperatorDescriptor("FnFloor",
                                 "floor",
                                 "(floor(a))"));
  m["unaryOps"].push_back(
              OperatorDescriptor("FnLog",
                                 "log",
                                 "(log(a))"));
  m["unaryOps"].push_back(
              OperatorDescriptor("FnLog10",
                                 "log10",
                                 "(log10(a))"));
  m["unaryOps"].push_back(
              OperatorDescriptor("FnSin",
                                 "sin",
                                 "(sin(a))"));
  m["unaryOps"].push_back(
              OperatorDescriptor("FnHypSin",
                                 "sinh",
                                 "(sinh(a))"));
  m["unaryOps"].push_back(
              OperatorDescriptor("FnSqrt",
                                 "sqrt",
                                 "(sqrt(a))"));
  m["unaryOps"].push_back(
              OperatorDescriptor("FnTan",
                                 "tan",
                                 "(tan(a))"));
  m["unaryOps"].push_back(
              OperatorDescriptor("FnHypTan",
                                 "tanh",
                                 "(tanh(a))"));
  m["unaryOps"].push_back(
              OperatorDescriptor("OpUnaryMinus",
                                 "operator-",
                                 "(-a)"));
  m["unaryOps"].push_back(
              OperatorDescriptor("OpUnaryPlus",
                                 "operator+",
                                 "(+a)"));
  m["unaryOps"].push_back(
              OperatorDescriptor("OpBitwiseNot",
                                 "operator~",
                                 "(~a)"));
  m["unaryOps"].push_back(
              OperatorDescriptor("OpIdentity",
                                 "PETE_identity",
                                 "(a)"));
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: PeteOps.cpp,v $   $Author: sa_smith $
// $Revision: 1.2 $   $Date: 1999/02/03 21:40:04 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
