// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called PETE (Portable Expression Template Engine) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-99-5.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No.  W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE, and to allow others to do so.
// The public may copy and use this SOFTWARE, FOR NONCOMMERCIAL USE ONLY,
// without charge, provided that this Notice and any statement of
// authorship are reproduced on all copies.  Neither the Government nor
// the University makes any warranty, express or implied, or assumes any
// liability or responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about PETE, send e-mail to pete@acl.lanl.gov,
// or visit the PETE web page at http://www.acl.lanl.gov/pete/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// Class:
// UnaryOp
// UnarySpecialOp
// UnaryBoolOp
// UnaryCastOp
// BinaryOp
// BinarySpecialOp
// BinaryBoolOp
// BinaryLeftOp
// BinaryAssignOp
// BinaryAssignBoolOp
// TrinaryOp
// InsertOp
//-----------------------------------------------------------------------------

#ifndef PETE_TOOLS_PRINTOPERATORS_H
#define PETE_TOOLS_PRINTOPERATORS_H

//////////////////////////////////////////////////////////////////////

//-----------------------------------------------------------------------------
// Overview: 
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Typedefs:
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Includes:
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Forward Declarations:
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
//
// Full Description:
//
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// UnaryOp
//
// This class prints the basic unary operater tag for operations which pass
// the type of the argument through.
//-----------------------------------------------------------------------------

class UnaryOp
{
public:
  template<class OSTR,class OPDEF>
  void print(OSTR& ostr,const OPDEF& opdef) const
  {
    ostr << endl
	 << "struct " << opdef.tag() << endl
	 << "{" << endl
	 << "  " << opdef.tag() << "() { }" << endl
	 << "  " << opdef.tag() << "(const " << opdef.tag() << "&) { }" << endl
	 << "  enum { tag = UnaryPassThruTag };" << endl
	 << "  template<class T>" << endl
	 << "  inline typename UnaryReturn<T, " << opdef.tag()
	 << ">::Type_t" << endl
	 << "  operator()(const T &a) const" << endl
	 << "  {" << endl
	 << "    return " << opdef.expression() << ";" << endl
	 << "  }" << endl
	 << "};" << endl;
  }
private:
};

//-----------------------------------------------------------------------------
// UnarySpecialOp
//
// This class prints the operator tag for unary operations that compute the
// return type by specializing the UnaryReturn struct.
//-----------------------------------------------------------------------------

class UnarySpecialOp
{
public:
  template<class OSTR,class OPDEF>
  void print(OSTR& ostr,const OPDEF& opdef) const
  {
    ostr << endl
	 << "struct " << opdef.tag() << endl
	 << "{" << endl
	 << "  " << opdef.tag() << "() { }" << endl
	 << "  " << opdef.tag() << "(const " << opdef.tag() << "&) { }" << endl
	 << "  enum { tag = 1 };" << endl
	 << "  template<class T>" << endl
	 << "  inline typename UnaryReturn<T, " << opdef.tag()
	 << ">::Type_t" << endl
	 << "  operator()(const T &a) const" << endl
	 << "  {" << endl
	 << "    return " << opdef.expression() << ";" << endl
	 << "  }" << endl
	 << "};" << endl;
  }
private:
};

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------

class UnaryBoolOp
{
public:
  template<class OSTR,class OPDEF>
  void print(OSTR& ostr,const OPDEF& opdef) const
  {
    ostr << endl
      << "struct " << opdef.tag() << "" << endl
      << "{" << endl
      << "  " << opdef.tag() << "() { }" << endl
      << "  " << opdef.tag() << "(const " << opdef.tag() << "&) { }" << endl
      << "  typedef bool Type_t;" << endl
      << "  enum { tag = Type2Index<bool>::val };" << endl
      << "  template<class T>" << endl
      << "  inline typename UnaryReturn<T, " << opdef.tag() << ">::Type_t" << endl
      << "  operator()(const T &a) const" << endl
      << "  {" << endl
      << "    return " << opdef.expression() << ";" << endl
      << "  }" << endl
      << "};" << endl;
  }
};

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------

class UnaryCastOp
{
public:
  template<class OSTR,class OPDEF>
  void print(OSTR& ostr,const OPDEF& opdef) const
  {
    ostr << endl
	 << "template <class T1>" << endl
	 << "struct " << opdef.tag() << "" << endl
	 << "{" << endl
	 << "  " << opdef.tag() << "() { }" << endl
	 << "  " << opdef.tag() << "(const " << opdef.tag()
	 << "<T1>&) { }" << endl
	 << "  typedef T1 Type_t;" << endl
	 << "  enum { tag = Type2Index<T1>::val };" << endl
	 << "  template<class T2>" << endl
	 << "  inline T1 operator()(const T2 &a) const" << endl
	 << "  {" << endl
	 << "    return " << opdef.expression() << ";" << endl
	 << "  }" << endl
	 << "};" << endl;
  }
private:
};

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------

class BinaryOp
{
public:
  template<class OSTR,class OPDEF>
  void print(OSTR& ostr,const OPDEF& opdef) const 
  {
    ostr << endl
	 << "struct " << opdef.tag() << "" << endl
	 << "{" << endl
	 << "  " << opdef.tag() << "() { }" << endl
	 << "  " << opdef.tag() << "(const " << opdef.tag()
	 << "&) { }" << endl
	 << "  enum { tag = BinaryPromoteTag };" << endl
	 << "  template<class T1, class T2>" << endl
	 << "  inline typename BinaryReturn<T1, T2, " << opdef.tag()
	 << ">::Type_t" << endl
	 << "  operator()(const T1 &a, const T2 &b) const" << endl
	 << "  {" << endl
	 << "    return " << opdef.expression() << ";" << endl
	 << "  }" << endl
	 << "};" << endl;
  }
private:
};

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------

class BinarySpecialOp
{
public:
  template<class OSTR,class OPDEF>
  void print(OSTR& ostr,const OPDEF& opdef) const 
  {
    ostr << endl
	 << "struct " << opdef.tag() << "" << endl
	 << "{" << endl
	 << "  " << opdef.tag() << "() { }" << endl
	 << "  " << opdef.tag() << "(const " << opdef.tag()
	 << "&) { }" << endl
	 << "  enum { tag = 1 };" << endl
	 << "  template<class T1, class T2>" << endl
	 << "  inline typename BinaryReturn<T1, T2, " << opdef.tag()
	 << ">::Type_t" << endl
	 << "  operator()(const T1 &a, const T2 &b) const" << endl
	 << "  {" << endl
	 << "    return " << opdef.expression() << ";" << endl
	 << "  }" << endl
	 << "};" << endl;
  }
private:
};

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------

class BinaryBoolOp
{
public:
  template<class OSTR,class OPDEF>
  void print(OSTR& ostr,const OPDEF& opdef) const
  {
    ostr << endl
	 << "struct " << opdef.tag() << "" << endl
	 << "{" << endl
	 << "  " << opdef.tag() << "() { }" << endl
	 << "  " << opdef.tag() << "(const " << opdef.tag() << "&) { }" << endl
	 << "  typedef bool Type_t;" << endl
	 << "  enum { tag = Type2Index<bool>::val };" << endl
	 << "  template<class T1, class T2>" << endl
	 << "  inline typename BinaryReturn<T1, T2, " << opdef.tag()
	 << ">::Type_t" << endl
	 << "  operator()(const T1 &a, const T2 &b) const" << endl
	 << "  {" << endl
	 << "    return " << opdef.expression() << ";" << endl
	 << "  }" << endl
	 << "};" << endl;
  }
private:
};

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------

class BinaryLeftOp
{
public:
  template<class OSTR,class OPDEF>
  void print(OSTR& ostr,const OPDEF& opdef) const
  {
    ostr << endl
	 << "struct " << opdef.tag() << "" << endl
	 << "{" << endl
	 << "  " << opdef.tag() << "() { }" << endl
	 << "  " << opdef.tag() << "(const " << opdef.tag() << "&) { }" << endl
	 << "  enum { tag = BinaryUseLeftTag };" << endl
	 << "  template<class T1, class T2>" << endl
	 << "  inline typename BinaryReturn<T1, T2, " << opdef.tag()
	 << ">::Type_t" << endl
	 << "  operator()(const T1 &a, const T2 &b) const" << endl
	 << "  {" << endl
	 << "    return " << opdef.expression() << ";" << endl
	 << "  }" << endl
	 << "};" << endl;
  }
private:
};

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------

class BinaryAssignOp
{
public:
  template<class OSTR,class OPDEF>
  void print(OSTR& ostr,const OPDEF& opdef) const
  {
    ostr << endl
	 << "struct " << opdef.tag() << "" << endl
	 << "{" << endl
	 << "  " << opdef.tag() << "() { }" << endl
	 << "  " << opdef.tag() << "(const " << opdef.tag() << "&) { }" << endl
	 << "  enum { tag = BinaryUseLeftTag };" << endl
	 << "  template<class T1, class T2>" << endl
	 << "  inline typename BinaryReturn<T1, T2, " << opdef.tag()
	 << ">::Type_t" << endl
	 << "  operator()(T1 &a, const T2 &b) const" << endl
	 << "  {" << endl
	 << "    return " << opdef.expression() << ";" << endl
	 << "  }" << endl
	 << "};" << endl;
  }
private:
};

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------

class BinaryAssignBoolOp
{
public:
  template<class OSTR,class OPDEF>
  void print(OSTR& ostr,const OPDEF& opdef) const
  {
    ostr << endl
	 << "struct " << opdef.tag() << "" << endl
	 << "{" << endl
	 << "  " << opdef.tag() << "() { }" << endl
	 << "  " << opdef.tag() << "(const " << opdef.tag() << "&) { }" << endl
	 << "  typedef bool Type_t;" << endl
	 << "  enum { tag = Type2Index<bool>::val };" << endl
	 << "  template<class T1, class T2>" << endl
	 << "  inline typename BinaryReturn<T1, T2, " << opdef.tag()
	 << ">::Type_t" << endl
	 << "  operator()(T1 &a, const T2 &b) const" << endl
	 << "  {" << endl
	 << "    return " << opdef.expression() << ";" << endl
	 << "  }" << endl
	 << "};" << endl;
  }
private:
};

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------

class TrinaryOp
{
public:
  template<class OSTR,class OPDEF>
  void print(OSTR& ostr,const OPDEF& opdef) const
  {
    ostr << endl
	 << "struct " << opdef.tag() << "" << endl
	 << "{" << endl
	 << "  " << opdef.tag() << "() { }" << endl
	 << "  " << opdef.tag() << "(const " << opdef.tag() << "&) { }" << endl
	 << "  enum { tag = BinaryPromoteTag };" << endl
	 << "  template<class T1, class T2, class T3>" << endl
	 << "  inline typename TrinaryReturn<T1, T2, T3, " << opdef.tag()
	 << ">::Type_t" << endl
	 << "  operator()(const T1 &a, const T2 &b,const T3 &c) const" << endl
	 << "  {" << endl
	 << "    return " << opdef.expression() << ";" << endl
	 << "  }" << endl
	 << "};" << endl;
  }
private:
};

//-----------------------------------------------------------------------------
// InsertOp
//
// This functor converts an operator descriptor into C++ code that can insert
// the operator into a map of vectors of operator descriptors.
// InsertOp should be constructed with the operator type string that says where
// in the map this type of operator is found.
//-----------------------------------------------------------------------------

class InsertOp
{
public:
  InsertOp(const string& optype) : optype_m(optype) { }
  template<class OSTR,class OPDEF>
  void print(OSTR& ostr,const OPDEF& opdef) const
  {
    ostr
      << "  m[\"" << optype_m << "\"].push_back(" << endl
      << "              OperatorDescriptor(\""
      << opdef.tag() << "\"," << endl
      << "                                 \""
      << opdef.function() << "\"," << endl
      << "                                 \""
      << opdef.expression() << "\"));"
      << endl;
  }
private:
  string optype_m;
};

//////////////////////////////////////////////////////////////////////

#endif     // PETE_TOOLS_PRINTOPERATORS_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: PrintOperators.h,v $   $Author: sa_smith $
// $Revision: 1.7 $   $Date: 1999/02/03 21:40:05 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
