#include "Tools/Parser.h"
#include "Tools/OperatorDescriptor.h"
#include <fstream.h>

#if defined(macintosh)
#include <console.h>
#endif

int main(int argc, char *argv[])
{
#if defined(macintosh)
  argc = ccommand(&argv);
#endif

  ifstream fin(argv[1]);
  
  map<string, vector<OperatorDescriptor> > m;  
  Parser<OperatorDescriptor> p(fin, argv[1],
			       "TAG", "FUNCTION", "EXPR", m);
  
  p.parse();
  
  map<string, vector<OperatorDescriptor> >::iterator i = m.begin();
  while (i != m.end())
    {
      cout << i->first << ":" << endl;
      vector<OperatorDescriptor> &v = i->second;
      vector<OperatorDescriptor>::iterator j = v.begin();
      while (j != v.end())
        cout << *j++;
      ++i;
    }
}
