#include "Tools/ClassDescriptor.h"
#include "Tools/OperatorDescriptor.h"
#include "Tools/PrintFunctions.h"
#include <iostream.h>

int main()
{
  ClassDescriptor c1(
    "int D[n], class T[n], class E[n]",
    "Array<D[n], T[n], E[n]>");

  OperatorDescriptor opAdd("OpAdd","operator+","( a + b )");
  BinaryFunction binary;
  binary.print(cout,opAdd,c1,c1);

  ClassDescriptor c2(
    "class T[n]",
    "vector<T[n]>");
    
  binary.print(cout,opAdd,c2,c2);
  binary.print(cout,opAdd,c1,c2);
}

