#include <stdio.h>
#include <stdlib.h>
#include "amx.h"

#define CONSOLE

void *loadprogram(AMX *amx,char *filename)
{
  FILE *fp;
  AMX_HEADER hdr;
  void *program = NULL;

  if ((fp=fopen(filename,"rb"))!=NULL) {
    fread(&hdr,sizeof hdr,1,fp);
    if ((program=malloc((int)hdr.stp))!=NULL) {
      rewind(fp);
      fread(program,1,(int)hdr.size,fp);
      fclose(fp);
      if (amx_Init(amx,program)==AMX_ERR_NONE)
	return program;
      free(program);
    } /* if */
  } /* if */
  return NULL;
}


int main(int argc,char *argv[])
{
extern int amx_Core(char *name, AMX_NATIVE *func);
#if defined(CONSOLE)
  extern int amx_Console(char *name, AMX_NATIVE *func);
#endif

  AMX amx;
  cell ret;
  int err;
  void *program;

  if (argc!=2 || (program=loadprogram(&amx,argv[1]))==NULL) {
    printf("Usage: AMXDEMO <filename>\n\n"
           "The filename must include the extension\n");
    return 1;
  } /* if */
  amx_Register(&amx,"core",amx_Core);
  #if defined(CONSOLE)
    amx_Register(&amx,"console",amx_Console);
  #endif

  err=amx_CheckModules(&amx);
  if (err==AMX_ERR_NONE)
    err=amx_Exec(&amx,&ret,-1,0);

  if (err!=AMX_ERR_NONE)
    printf("Run time error %d on line %ld\n",err,amx.curline);
  else if (ret!=0)
    printf("%s returns %ld\n",argv[1],(long)ret);

  amx_Unregister(&amx,"core",amx_Core);
  #if defined(CONSOLE)
    amx_Unregister(&amx,"console",amx_Console);
  #endif
  amx_Release(&amx);
  free(program);
  return 0;
}

