/*  Small compiler
 *
 *  Error message system.
 *  In fact a very simple system, using only 'panic mode'.
 */
#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>     /* ANSI standardised variable argument list functions */
#include <string.h>
#include "sc.h"

static char *errmsg[] = {
         "Error [001]: expected token: \"%s\", but found \"%s\"\n",
         "Error [002]: local variables not allowed within \"switch\"\n",
         "Error [003]: local variables disallowed between \"goto\" and its label\n",
         "Error [004]: function \"%s\" not defined\n",
         "Error [005]: function may not have arguments\n",
         "Error [006]: must be assigned to an array\n",
         "Error [007]: assertion failed\n",
         "Error [008]: must be a constant expression; assumed zero\n",
         "Error [009]: invalid array size (negative or zero)\n",
         "Error [010]: invalid function or declaration\n",
         "Error [011]: invalid outside functions\n",
         "Error [012]: invalid function call, not a valid address\n",
         "Error [013]: no entry point (no public functions)\n",
         "Error [014]: invalid statement; not in switch\n",
         "Error [015]: \"default\" case must be the last case in switch statement\n",
         "Error [016]: multiple defaults in \"switch\"\n",
         "Error [017]: undefined symbol \"%s\"\n",
         "Error [018]: initialization data exceeds declared size\n",
         "Error [019]: not a label: \"%s\"\n",
         "Error [020]: invalid symbol name \"%s\"\n",
         "Error [021]: symbol already defined: \"%s\"\n",
         "Error [022]: must be lvalue\n",
         "Error [023]: cannot take address from constant\n",
         "Error [024]: \"break\" or \"continue\" is out of context\n",
         "Error [025]: function heading differs from prototype\n",
         "Error [026]: no matching \"#if...\"\n",
         "Error [027]: invalid character constant\n",
         "Error [028]: cannot subscript, not an array\n",
         "Error [029]: invalid expression, assumed zero\n",
         "Error [030]: compound statement not closed at the end of file\n",
         "Error [031]: unknown directive\n",
         "Error [032]: array index out of bounds (variable \"%s\")\n",
         "Error [033]: array must be indexed (variable \"%s\")\n",
         "Error [034]: argument does not have a default value (argument %d)\n",
         "Error [035]: argument type mismatch (argument %d)\n",
         "Error [036]: empty statement\n",
         "Error [037]: invalid string\n",
         "Error [038]: extra characters on line\n",
         "Error [039]: constant symbol has no size\n",
         "Error [040]: duplicate \"case\" label (value %d)\n",
         "Error [041]: invalid ellipsis, array size is not known\n"
       };

static char *fatalmsg[] = {
         "Fatal [100]: cannot read from file: \"%s\"\n",
         "Fatal [101: cannot write to file: \"%s\"\n",
         "Fatal [102]: table overflow: \"%s\"\n",
          /* table can be: loop table
           *               staging buffer
           *               parser stack (recursive include?)
           *               label table
           */
         "Fatal [103]: insufficient memory\n"
       };

static char *warnmsg[] = {
         "Warning [200]: symbol is truncated to 16 characters\n",
         "Warning [201]: redefinition of constant (name \"%s\")\n",
         "Warning [202]: number of arguments does not match definition\n",
         "Warning [203]: symbol is never used: \"%s\"\n",
         "Warning [204]: symbol is assigned a value that is never used: \"%s\"\n",
         "Warning [205]: redundant code: constant expression is zero\n",
         "Warning [206]: redundant test: constant expression is non-zero\n",
         "Warning [207]: unknown #pragma\n",
         "Warning [208]: function uses both \"return;\" and \"return <value>;\"\n",
         "Warning [209]: function should return a value\n",
         "Warning [210]: possible use of symbol before initialisation: \"%s\"\n",
         "Warning [211]: possibly unintended assignment\n",
         "Warning [212]: possibly unintended bitwise operation\n",
         "Warning [213]: tagname mismatch\n",
         "Warning [214]: ambiguous mix of operators, use parantheses\n"
       };

/*  error
 *
 *  Outputs an error message (note: msg is passed optionally).
 *  If an error is found, the variable "errflag" is set an subsequent
 *  errors are ignored until lex() finds a semicolumn (lex() resets
 *  "errflag" in that case).
 *
 *  Global references: inpfname   (reffered to only)
 *                     lineno     (reffered to only)
 *                     verbose    (reffered to only)
 *                     lptr,pline (reffered to only)
 *                     errflag    (altered)
 */
void error(int number,...)
{
  char *s2;
  int column,i;
  va_list argptr;

  if (errflag>0)        /* errflag is reset on each semicolon */
    return;

  column= (int)(lptr-pline)-1;  /* error probably occurred before current position */
  if (column<1)
    column=1;

  if (number<100){
    s2=errmsg[number-1];
    errflag=1;          /* set errflag (skip rest of erroneous expression) */
    errnum++;
  } else if (number<200){
    s2=fatalmsg[number-100];
  } else {
    s2=warnmsg[number-200];
    warnnum++;
  } /* if */

  assert(!(verbose && strlen(errfname)>0));
  if (verbose){         /* write erroneous line and move a pointer ^ to... */
    printf("%s",pline); /* ...the error position */
    i=0;
    while (i++<column)
      putchar(' ');
    puts("^");
  } /* if */
  if (strlen(errfname)==0) {
    printf("%s(%d) ",inpfname,fline);
    va_start(argptr,number);
    vprintf(s2,argptr);
  } else {
    FILE *fp=fopen(errfname,"at");
    if (fp!=NULL) {
      fprintf(fp,"%s(%d) ",inpfname,fline);
      va_start(argptr,number);
      vfprintf(fp,s2,argptr);
      fclose(fp);
    } /* if */
  } /* if */

  if (number>=100 && number<200 || errnum>25){
    if (strlen(errfname)==0)
      puts("\nCompilation aborted.");
    unlink(outfname);
    exit(1);      /* fatal error, quit */
  } /* if */
}

