/*  Small compiler
 *
 *  Global (cross-module) variables.
 */
#include <stdio.h>
#include "sc.h"

/*  global variables
 *
 *  Not all global variables are declared here.
 */
symbol loctab;          /* local symbol table */
symbol glbtab;          /* global symbol table */
cell *litq;             /* the literal queue */
char pline[_linemax+1]; /* the line read from the input file */
char *lptr;             /* points to the current position in "pline" */
constval mod_tab = { "", 0, NULL};      /* module table */
constval tagname_tab = { "", 0, NULL};  /* tagname table */
cell *lbltab;           /* label table */
char *inpfname;         /* pointer to name of the file currently read from */
char outfname[_linemax+1];      /* output file name */
char binfname[_linemax+1];      /* binary file name */
char errfname[_linemax+1];      /* error file name */
char includepath[_linemax+1];   /* directory for system include files */

char ctrlchar = '^';    /* the control character (or escape character) */
int wq[_wqtabsz];
int *wqptr;             /* pointer to next entry */
int litidx    = 0;      /* index to literal table */
int litmax    = _def_litmax;    /* current size of the literal table */
int stgidx    = 0;      /* index to the staging buffer */
int staging   = 0;      /* true if staging output */
int rettype;            /* the type that a "return" expression should have */
cell declared;          /* number of local cells declared */
cell glb_declared=0;    /* number of global bytes declared */
cell code_idx = 0;      /* number of bytes with generated code */
int ncmp      = 0;      /* number of active (open) compound statements */
int ext_funcid= 0;      /* incremental number of external function */
int errflag   = 0;      /* 1 after first error in statement, -1 if no... */
                        /* ...error on current line, but errors were found */
int errnum    = 0;      /* number of errors */
int warnnum   = 0;      /* number of warnings */
int lastst    = 0;      /* last executed statement type */
int listing   = _no;    /* create .ASM file? */
int verbose   = _no;    /* display extra information while compiling? */
int debug     = (_chkbounds | _symbolic);   /* by default: full debug info */
int curseg    = 0;      /* 1 if currently parsing CODE, 2 if parsing DATA */
cell stksize  = 2048;   /* default stack size */
int freading  = _no;    /* Is there an input file ready for reading? */
int fline     = 0;      /* the line number in the current file */
int fnumber   = 0;      /* the file number in the file table (debugging) */
int intest    = 0;      /* true if inside a test */

FILE *inpf;             /* file read from */
FILE *outf;             /* file written to */

