# Caption
#  Getting and setting an atom's charge using (a) toolkit function
#  calls and (b) attributes.  (C) shows how attributes are converted
#  to function calls.

# Part (a)  <a name="a">
print "The charge is", dt_charge(atom)
dt_setcharge(atom, 1)

# Part (b)  <a name="b">
print "The charge is", atom.charge
atom.charge = 1

# Part (c)  <a name="c">
class Atom:
    def __init__(self, handle):
        self.handle = handle
    def __int__(self):
        return int(self.handle)
    def __getattr__(self, name):
        if name == "charge":
            return dt_charge(self.handle)
        elif name == "symbol":
            return dt_symbol(self.handle)
        raise AttributeError, name
    def __setattr__(self, name, val):
        if name == "charge":
            dt_setcharge(self.handle, val)
        elif name == "symbol":
            raise TypeError, "readonly attribute"
        else:
            self.__dict__[name] = val

